/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.registry;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.openapi.util.NlsSafe;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValueListener;
import org.jetbrains.kotlin.com.intellij.util.MathUtil;
import org.jetbrains.kotlin.org.jdom.Element;

public final class Registry {
    private static Reference<Map<String, String>> bundledRegistry;
    @NonNls
    public static final String REGISTRY_BUNDLE = "misc.registry";
    private static final RegistryValueListener EMPTY_VALUE_LISTENER;
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final Map<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private Map<String, RegistryKeyDescriptor> myContributedKeys = Collections.emptyMap();
    private static final Registry ourInstance;
    private volatile boolean isLoaded;
    @NotNull
    private volatile RegistryValueListener valueChangeListener = EMPTY_VALUE_LISTENER;

    @NotNull
    public static RegistryValue get(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(0);
        }
        return Registry.getInstance().doGet(key);
    }

    @ApiStatus.Internal
    @NotNull
    public static RegistryValue _getWithoutStateCheck(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(1);
        }
        return ourInstance.doGet(key);
    }

    @NotNull
    private RegistryValue doGet(@NonNls @NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(2);
        }
        RegistryValue registryValue = this.myValues.computeIfAbsent(key, s -> new RegistryValue(this, (String)s, this.myContributedKeys.get(s)));
        if (registryValue == null) {
            Registry.$$$reportNull$$$0(3);
        }
        return registryValue;
    }

    public static boolean is(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(4);
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@NonNls @NotNull String key, boolean defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(5);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return defaultValue;
        }
        try {
            return Registry.getInstance().doGet(key).asBoolean();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static int intValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(6);
        }
        return Registry.getInstance().doGet(key).asInteger();
    }

    public static int intValue(@NonNls @NotNull String key, int defaultValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(7);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            LoadingState.COMPONENTS_REGISTERED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.getInstance().doGet(key).asInteger();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    @TestOnly
    void reset() {
        this.myUserProperties.clear();
        this.myValues.clear();
        this.isLoaded = false;
    }

    public static double doubleValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(8);
        }
        return Registry.get(key).asDouble();
    }

    @NotNull
    public static String stringValue(@NonNls @NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(9);
        }
        String string2 = Registry.get(key).asString();
        if (string2 == null) {
            Registry.$$$reportNull$$$0(10);
        }
        return string2;
    }

    public static Color getColor(@NonNls @NotNull String key, Color defaultValue) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(11);
        }
        return Registry.get(key).asColor(defaultValue);
    }

    @Nullable
    private static Map<String, String> loadFromBundledConfig() throws IOException {
        Map<String, String> result2;
        Reference<Map<String, String>> bundleRef = bundledRegistry;
        Map<String, String> map2 = result2 = bundleRef == null ? null : bundleRef.get();
        if (result2 != null) {
            return result2;
        }
        LinkedHashMap<String, String> map3 = new LinkedHashMap<String, String>(1800);
        boolean mainFound = Registry.loadFromResource("misc/registry.properties", map3);
        boolean overrideFound = Registry.loadFromResource("misc/registry.override.properties", map3);
        if (!mainFound && !overrideFound) {
            return null;
        }
        bundledRegistry = new SoftReference<LinkedHashMap<String, String>>(map3);
        return map3;
    }

    private static boolean loadFromResource(String sourceResourceName, final Map<String, String> targetMap) throws IOException {
        InputStream stream = Registry.class.getClassLoader().getResourceAsStream(sourceResourceName);
        if (stream == null) {
            return false;
        }
        try {
            new Properties(){

                @Override
                public Object put(Object key, Object value2) {
                    return targetMap.put((String)key, (String)value2);
                }
            }.load(stream);
        }
        finally {
            stream.close();
        }
        return true;
    }

    @NlsSafe
    @Nullable
    public String getBundleValueOrNull(@NonNls @NotNull String key) {
        RegistryKeyDescriptor contributed;
        if (key == null) {
            Registry.$$$reportNull$$$0(12);
        }
        if ((contributed = this.myContributedKeys.get(key)) != null) {
            return contributed.getDefaultValue();
        }
        try {
            Map<String, String> bundle = Registry.loadFromBundledConfig();
            return bundle == null ? null : bundle.get(key);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NlsSafe
    @NotNull
    String getBundleValue(@NonNls @NotNull String key) throws MissingResourceException {
        RegistryKeyDescriptor contributed;
        if (key == null) {
            Registry.$$$reportNull$$$0(13);
        }
        if ((contributed = this.myContributedKeys.get(key)) != null) {
            String string2 = contributed.getDefaultValue();
            if (string2 == null) {
                Registry.$$$reportNull$$$0(14);
            }
            return string2;
        }
        String result2 = this.getBundleValueOrNull(key);
        if (result2 == null) {
            throw new MissingResourceException("Registry key " + key + " is not defined", REGISTRY_BUNDLE, key);
        }
        String string3 = result2;
        if (string3 == null) {
            Registry.$$$reportNull$$$0(15);
        }
        return string3;
    }

    @NotNull
    public static Registry getInstance() {
        LoadingState.COMPONENTS_LOADED.checkOccurred();
        Registry registry = ourInstance;
        if (registry == null) {
            Registry.$$$reportNull$$$0(16);
        }
        return registry;
    }

    @NotNull
    public Element getState() {
        Element state = new Element("registry");
        for (Map.Entry<String, String> entry2 : this.myUserProperties.entrySet()) {
            RegistryValue registryValue = Registry.get(entry2.getKey());
            if (!registryValue.isChangedFromDefault()) continue;
            Element entryElement = new Element("entry");
            entryElement.setAttribute("key", entry2.getKey());
            entryElement.setAttribute("value", entry2.getValue());
            state.addContent(entryElement);
        }
        Element element = state;
        if (element == null) {
            Registry.$$$reportNull$$$0(17);
        }
        return element;
    }

    public static int intValue(@NonNls @NotNull String key, int defaultValue, int minValue, int maxValue) {
        if (key == null) {
            Registry.$$$reportNull$$$0(18);
        }
        if (defaultValue < minValue || defaultValue > maxValue) {
            throw new IllegalArgumentException("Wrong values for default:min:max (" + defaultValue + ":" + minValue + ":" + maxValue + ")");
        }
        return MathUtil.clamp(Registry.intValue(key, defaultValue), minValue, maxValue);
    }

    @NotNull
    private static Map<String, String> fromState(@NotNull Element state) {
        if (state == null) {
            Registry.$$$reportNull$$$0(19);
        }
        LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>();
        for (Element eachEntry : state.getChildren("entry")) {
            String key = eachEntry.getAttributeValue("key");
            String value2 = eachEntry.getAttributeValue("value");
            if (key == null || value2 == null) continue;
            map2.put(key, value2);
        }
        LinkedHashMap<String, String> linkedHashMap = map2;
        if (linkedHashMap == null) {
            Registry.$$$reportNull$$$0(20);
        }
        return linkedHashMap;
    }

    @NotNull
    private static Map<String, String> updateStateInternal(@NotNull Registry registry, @Nullable Element state) {
        if (registry == null) {
            Registry.$$$reportNull$$$0(21);
        }
        Map<String, String> userProperties = registry.myUserProperties;
        if (state == null) {
            userProperties.clear();
            Map<String, String> map2 = userProperties;
            if (map2 == null) {
                Registry.$$$reportNull$$$0(22);
            }
            return map2;
        }
        Map<String, String> map3 = Registry.fromState(state);
        HashSet<String> keys2process = new HashSet<String>(userProperties.keySet());
        for (Map.Entry<String, String> entry2 : map3.entrySet()) {
            RegistryValue registryValue = registry.doGet(entry2.getKey());
            String currentValue = registryValue.get(entry2.getKey(), null, false);
            if (currentValue != null && !currentValue.equals(entry2.getValue())) {
                registryValue.setValue(entry2.getValue());
            }
            keys2process.remove(entry2.getKey());
        }
        for (String key : keys2process) {
            registry.doGet(key).resetToDefault();
        }
        Map<String, String> map4 = userProperties;
        if (map4 == null) {
            Registry.$$$reportNull$$$0(23);
        }
        return map4;
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<String, String> loadState(@Nullable Element state, @Nullable Map<String, String> earlyAccess) {
        Registry registry = ourInstance;
        if (registry.isLoaded) {
            return Registry.updateStateInternal(registry, state);
        }
        return Registry.loadStateInternal(registry, state, earlyAccess);
    }

    @ApiStatus.Internal
    public static void markAsLoaded() {
        Registry.ourInstance.isLoaded = true;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @NotNull
    Map<String, String> getUserProperties() {
        Map<String, String> map2 = this.myUserProperties;
        if (map2 == null) {
            Registry.$$$reportNull$$$0(24);
        }
        return map2;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<RegistryValue> getAll() {
        Map<String, String> bundle = null;
        try {
            bundle = Registry.loadFromBundledConfig();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Set<Object> keys = bundle == null ? Collections.emptySet() : bundle.keySet();
        ArrayList<RegistryValue> result2 = new ArrayList<RegistryValue>();
        Registry instance = ourInstance;
        Map<String, RegistryKeyDescriptor> contributedKeys = instance.myContributedKeys;
        for (String string2 : keys) {
            if (string2.endsWith(".description") || string2.endsWith(".restartRequired") || contributedKeys.containsKey(string2)) continue;
            result2.add(instance.doGet(string2));
        }
        for (String string3 : contributedKeys.keySet()) {
            result2.add(instance.doGet(string3));
        }
        ArrayList<RegistryValue> arrayList = result2;
        if (arrayList == null) {
            Registry.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    void restoreDefaults() {
        LinkedHashMap<String, String> old = new LinkedHashMap<String, String>(this.myUserProperties);
        Registry instance = Registry.getInstance();
        for (String key : old.keySet()) {
            String v = instance.getBundleValueOrNull(key);
            if (v == null) {
                this.myValues.remove(key);
                continue;
            }
            RegistryValue value2 = instance.myValues.get(key);
            if (value2 == null) continue;
            value2.setValue(v);
        }
    }

    boolean isInDefaultState() {
        return this.myUserProperties.isEmpty();
    }

    public boolean isRestartNeeded() {
        return Registry.isRestartNeeded(this.myUserProperties);
    }

    private static boolean isRestartNeeded(@NotNull Map<String, String> map2) {
        if (map2 == null) {
            Registry.$$$reportNull$$$0(26);
        }
        Registry instance = Registry.getInstance();
        for (String s : map2.keySet()) {
            RegistryValue eachValue = instance.doGet(s);
            if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static synchronized void setKeys(@NotNull Map<String, RegistryKeyDescriptor> descriptors) {
        if (descriptors == null) {
            Registry.$$$reportNull$$$0(27);
        }
        Registry.ourInstance.myContributedKeys = descriptors;
    }

    @ApiStatus.Internal
    public static synchronized void mutateContributedKeys(@NotNull Function<? super Map<String, RegistryKeyDescriptor>, ? extends Map<String, RegistryKeyDescriptor>> mutator) {
        if (mutator == null) {
            Registry.$$$reportNull$$$0(28);
        }
        Registry.ourInstance.myContributedKeys = mutator.apply(Registry.ourInstance.myContributedKeys);
    }

    @ApiStatus.Internal
    public static void setValueChangeListener(@Nullable RegistryValueListener listener) {
        Registry.ourInstance.valueChangeListener = listener == null ? EMPTY_VALUE_LISTENER : listener;
    }

    @NotNull
    RegistryValueListener getValueChangeListener() {
        RegistryValueListener registryValueListener = this.valueChangeListener;
        if (registryValueListener == null) {
            Registry.$$$reportNull$$$0(29);
        }
        return registryValueListener;
    }

    @NotNull
    private static Map<String, String> loadStateInternal(@NotNull Registry registry, @Nullable Element state, @Nullable Map<String, String> earlyAccess) {
        if (registry == null) {
            Registry.$$$reportNull$$$0(30);
        }
        Map<String, String> userProperties = registry.myUserProperties;
        userProperties.clear();
        if (state != null) {
            Map<String, String> map2 = Registry.fromState(state);
            for (Map.Entry<String, String> entry2 : map2.entrySet()) {
                RegistryValue registryValue = registry.doGet(entry2.getKey());
                if (!registryValue.isChangedFromDefault(entry2.getValue(), registry)) continue;
                userProperties.put(entry2.getKey(), entry2.getValue());
                registryValue.resetCache();
            }
        }
        if (earlyAccess != null) {
            userProperties.putAll(earlyAccess);
        }
        registry.isLoaded = true;
        Map<String, String> map3 = userProperties;
        if (map3 == null) {
            Registry.$$$reportNull$$$0(31);
        }
        return map3;
    }

    static {
        EMPTY_VALUE_LISTENER = new RegistryValueListener(){};
        ourInstance = new Registry();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "stringValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "fromState";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "updateStateInternal";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserProperties";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueChangeListener";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "loadStateInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_getWithoutStateCheck";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doGet";
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 6: 
            case 7: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "intValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doubleValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stringValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValueOrNull";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fromState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateStateInternal";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isRestartNeeded";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setKeys";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "mutateContributedKeys";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "loadStateInternal";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

