/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.IntObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.RefValueHashMapUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.SimpleEntry;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectIterator;

final class IntKeyWeakValueHashMap<V>
implements IntObjectMap<V> {
    private final Int2ObjectMap<MyReference<V>> myMap = new Int2ObjectOpenHashMap<MyReference<V>>();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    IntKeyWeakValueHashMap() {
    }

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            int key = ref.key;
            this.myMap.remove(key);
        }
        return;
    }

    @Override
    public V get(int key) {
        return (V)SoftReference.dereference((Reference)this.myMap.get(key));
    }

    @Override
    public V put(int key, @NotNull V value2) {
        if (value2 == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(0);
        }
        this.processQueue();
        MyReference ref = new MyReference(key, value2, this.myQueue);
        MyReference oldRef = this.myMap.put(key, ref);
        return (V)SoftReference.dereference(oldRef);
    }

    @Override
    public V remove(int key) {
        this.processQueue();
        MyReference ref = (MyReference)this.myMap.remove(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(int key) {
        throw RefValueHashMapUtil.pointlessContainsKey();
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull V> values() {
        Collection refs = this.myMap.values();
        ArrayList result2 = new ArrayList(refs.size());
        for (MyReference o : refs) {
            Object value2 = o.get();
            if (value2 == null) continue;
            result2.add(value2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public int @NotNull [] keys() {
        throw new IncorrectOperationException("keys() makes no sense for weak/soft map because GC can clear the value any moment now");
    }

    @Override
    public boolean containsValue(@NotNull V value2) {
        if (value2 == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(2);
        }
        return this.values().contains(value2);
    }

    @Override
    @NotNull
    public Set<IntObjectMap.Entry<V>> entrySet() {
        return new MyEntrySetView();
    }

    @NotNull
    private Iterator<IntObjectMap.Entry<V>> entriesIterator() {
        Iterator entryIterator = this.myMap.int2ObjectEntrySet().iterator();
        return new Iterator<IntObjectMap.Entry<V>>(){
            private IntObjectMap.Entry<V> nextVEntry;
            private int lastReturned;
            final /* synthetic */ ObjectIterator val$entryIterator;
            {
                this.val$entryIterator = objectIterator;
                this.nextAliveEntry();
            }

            @Override
            public boolean hasNext() {
                return this.nextVEntry != null;
            }

            @Override
            public IntObjectMap.Entry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IntObjectMap.Entry result2 = this.nextVEntry;
                this.lastReturned = result2.getKey();
                this.nextAliveEntry();
                return result2;
            }

            private void nextAliveEntry() {
                while (this.val$entryIterator.hasNext()) {
                    Int2ObjectMap.Entry entry2 = (Int2ObjectMap.Entry)this.val$entryIterator.next();
                    MyReference ref = (MyReference)entry2.getValue();
                    Object v = ref.get();
                    if (v == null) continue;
                    int key = entry2.getIntKey();
                    this.nextVEntry = new SimpleEntry(key, v);
                    return;
                }
                this.nextVEntry = null;
            }

            @Override
            public void remove() {
                IntKeyWeakValueHashMap.this.myMap.remove(this.lastReturned);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/IntKeyWeakValueHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/IntKeyWeakValueHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyReference<T>
    extends WeakReference<T> {
        private final int key;

        private MyReference(int key, @NotNull T referent, ReferenceQueue<? super T> q) {
            if (referent == null) {
                MyReference.$$$reportNull$$$0(0);
            }
            super(referent, q);
            this.key = key;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "org/jetbrains/kotlin/com/intellij/util/containers/IntKeyWeakValueHashMap$MyReference", "<init>"));
        }
    }

    private final class MyEntrySetView
    extends AbstractSet<IntObjectMap.Entry<V>> {
        private MyEntrySetView() {
        }

        @Override
        @NotNull
        public Iterator<IntObjectMap.Entry<V>> iterator() {
            Iterator iterator2 = IntKeyWeakValueHashMap.this.entriesIterator();
            if (iterator2 == null) {
                MyEntrySetView.$$$reportNull$$$0(0);
            }
            return iterator2;
        }

        @Override
        public int size() {
            return IntKeyWeakValueHashMap.this.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/IntKeyWeakValueHashMap$MyEntrySetView", "iterator"));
        }
    }
}

