/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.graph;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.UnmodifiableIterator;
import org.jetbrains.kotlin.com.intellij.util.graph.Graph;
import org.jetbrains.kotlin.com.intellij.util.graph.Network;

public abstract class EndpointPair<N>
implements Iterable<N> {
    private final N myNodeU;
    private final N myNodeV;

    private EndpointPair(N nodeU, N nodeV) {
        this.myNodeU = Objects.requireNonNull(nodeU);
        this.myNodeV = Objects.requireNonNull(nodeV);
    }

    public static <N> EndpointPair<N> ordered(N source2, N target2) {
        return new Ordered(source2, target2);
    }

    public static <N> EndpointPair<N> unordered(N nodeU, N nodeV) {
        return new Unordered(nodeV, nodeU);
    }

    static <N> EndpointPair<N> of(Graph<?> graph, N nodeU, N nodeV) {
        return EndpointPair.unordered(nodeU, nodeV);
    }

    static <N> EndpointPair<N> of(Network<?, ?> network, N nodeU, N nodeV) {
        return network.isDirected() ? EndpointPair.ordered(nodeU, nodeV) : EndpointPair.unordered(nodeU, nodeV);
    }

    public abstract N source();

    public abstract N target();

    public final N nodeU() {
        return this.myNodeU;
    }

    public final N nodeV() {
        return this.myNodeV;
    }

    public final N adjacentNode(Object node2) {
        if (node2.equals(this.myNodeU)) {
            return this.myNodeV;
        }
        if (node2.equals(this.myNodeV)) {
            return this.myNodeU;
        }
        throw new IllegalArgumentException("EndpointPair " + this + " does not contain node " + node2);
    }

    public abstract boolean isOrdered();

    @Override
    public final UnmodifiableIterator<N> iterator() {
        return new UnmodifiableIterator<Object>(Arrays.asList(this.myNodeU, this.myNodeV).iterator());
    }

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    private static final class Ordered<N>
    extends EndpointPair<N> {
        private Ordered(N source2, N target2) {
            super(source2, target2);
        }

        @Override
        public N source() {
            return this.nodeU();
        }

        @Override
        public N target() {
            return this.nodeV();
        }

        @Override
        public boolean isOrdered() {
            return true;
        }

        @Override
        public boolean equals(@Nullable Object obj2) {
            if (obj2 == this) {
                return true;
            }
            if (!(obj2 instanceof EndpointPair)) {
                return false;
            }
            EndpointPair other = (EndpointPair)obj2;
            if (this.isOrdered() != other.isOrdered()) {
                return false;
            }
            return this.source().equals(other.source()) && this.target().equals(other.target());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.source(), this.target());
        }

        public String toString() {
            return "<" + this.source() + " -> " + this.target() + ">";
        }
    }

    private static final class Unordered<N>
    extends EndpointPair<N> {
        private Unordered(N nodeU, N nodeV) {
            super(nodeU, nodeV);
        }

        @Override
        public N source() {
            throw new UnsupportedOperationException("Not available on undirected graph");
        }

        @Override
        public N target() {
            throw new UnsupportedOperationException("Not available on undirected graph");
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        public boolean equals(@Nullable Object obj2) {
            if (obj2 == this) {
                return true;
            }
            if (!(obj2 instanceof EndpointPair)) {
                return false;
            }
            EndpointPair other = (EndpointPair)obj2;
            if (this.isOrdered() != other.isOrdered()) {
                return false;
            }
            if (this.nodeU().equals(other.nodeU())) {
                return this.nodeV().equals(other.nodeV());
            }
            return this.nodeU().equals(other.nodeV()) && this.nodeV().equals(other.nodeU());
        }

        @Override
        public int hashCode() {
            return this.nodeU().hashCode() + this.nodeV().hashCode();
        }

        public String toString() {
            return "[" + this.nodeU() + ", " + this.nodeV() + "]";
        }
    }
}

