/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing;

import java.util.Collection;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.util.indexing.InvertedIndex;
import org.jetbrains.kotlin.com.intellij.util.indexing.StorageException;
import org.jetbrains.kotlin.com.intellij.util.indexing.ValueContainer;
import org.jetbrains.kotlin.com.intellij.util.io.IOCancellationCallbackHolder;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntSet;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntSets;

public final class InvertedIndexUtil {
    @NotNull
    public static <K, V, I> IntSet collectInputIdsContainingAllKeys(@NotNull InvertedIndex<? super K, V, I> index, @NotNull Collection<? extends K> dataKeys, @Nullable Condition<? super V> valueChecker, @Nullable IntPredicate idChecker) throws StorageException {
        if (index == null) {
            InvertedIndexUtil.$$$reportNull$$$0(0);
        }
        if (dataKeys == null) {
            InvertedIndexUtil.$$$reportNull$$$0(1);
        }
        IntOpenHashSet mainIntersection = null;
        for (K dataKey : dataKeys) {
            IOCancellationCallbackHolder.checkCancelled();
            IntOpenHashSet copy2 = new IntOpenHashSet();
            ValueContainer<V> container = index.getData(dataKey);
            ValueContainer.ValueIterator<V> valueIt = container.getValueIterator();
            while (valueIt.hasNext()) {
                IntPredicate predicate;
                Object value2 = valueIt.next();
                if (valueChecker != null && !valueChecker.value(value2)) continue;
                IOCancellationCallbackHolder.checkCancelled();
                ValueContainer.IntIterator iterator2 = valueIt.getInputIdsIterator();
                if (mainIntersection == null || iterator2.size() < mainIntersection.size() || (predicate = valueIt.getValueAssociationPredicate()) == null) {
                    while (iterator2.hasNext()) {
                        int id = iterator2.next();
                        if ((mainIntersection != null || idChecker != null && !idChecker.test(id)) && (mainIntersection == null || !mainIntersection.contains(id))) continue;
                        copy2.add(id);
                    }
                    continue;
                }
                IntIterator intIterator = mainIntersection.iterator();
                while (intIterator.hasNext()) {
                    int id = intIterator.nextInt();
                    if (!predicate.test(id) || idChecker != null && !idChecker.test(id)) continue;
                    copy2.add(id);
                }
            }
            mainIntersection = copy2;
            if (!mainIntersection.isEmpty()) continue;
            IntSets.EmptySet emptySet = IntSets.EMPTY_SET;
            if (emptySet == null) {
                InvertedIndexUtil.$$$reportNull$$$0(2);
            }
            return emptySet;
        }
        AbstractIntCollection abstractIntCollection = mainIntersection == null ? IntSets.EMPTY_SET : mainIntersection;
        if (abstractIntCollection == null) {
            InvertedIndexUtil.$$$reportNull$$$0(3);
        }
        return abstractIntCollection;
    }

    @NotNull
    public static <K, V, I> IntSet collectInputIdsContainingAnyKey(@NotNull InvertedIndex<? super K, V, I> index, @NotNull Collection<? extends K> dataKeys, @Nullable Condition<? super V> valueChecker, @Nullable IntPredicate idChecker) throws StorageException {
        if (index == null) {
            InvertedIndexUtil.$$$reportNull$$$0(4);
        }
        if (dataKeys == null) {
            InvertedIndexUtil.$$$reportNull$$$0(5);
        }
        IntCollection result2 = null;
        for (K dataKey : dataKeys) {
            IOCancellationCallbackHolder.checkCancelled();
            ValueContainer<V> container = index.getData(dataKey);
            ValueContainer.ValueIterator<V> valueIt = container.getValueIterator();
            while (valueIt.hasNext()) {
                Object value2 = valueIt.next();
                if (valueChecker != null && !valueChecker.value(value2)) continue;
                IOCancellationCallbackHolder.checkCancelled();
                ValueContainer.IntIterator iterator2 = valueIt.getInputIdsIterator();
                while (iterator2.hasNext()) {
                    int id = iterator2.next();
                    if (idChecker != null && !idChecker.test(id)) continue;
                    if (result2 == null) {
                        result2 = new IntOpenHashSet();
                    }
                    result2.add(id);
                }
            }
        }
        IntCollection intCollection = result2 == null ? IntSets.EMPTY_SET : result2;
        if (intCollection == null) {
            InvertedIndexUtil.$$$reportNull$$$0(6);
        }
        return intCollection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/InvertedIndexUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/InvertedIndexUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInputIdsContainingAllKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInputIdsContainingAnyKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInputIdsContainingAllKeys";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInputIdsContainingAnyKey";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

