/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.CharSequenceWithStringHash;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;

public final class ByteArrayCharSequence
implements CharSequenceWithStringHash {
    private final int myStart;
    private final int myEnd;
    private transient int hash;
    private final byte[] myChars;

    public ByteArrayCharSequence(byte @NotNull [] chars) {
        if (chars == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(0);
        }
        this(chars, 0, chars.length);
    }

    public ByteArrayCharSequence(byte @NotNull [] chars, int start2, int end) {
        if (chars == null) {
            ByteArrayCharSequence.$$$reportNull$$$0(1);
        }
        this.myChars = chars;
        this.myStart = start2;
        this.myEnd = end;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    @Override
    public int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public char charAt(int index) {
        return (char)(this.myChars[index + this.myStart] & 0xFF);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start2, int end) {
        return start2 == 0 && end == this.length() ? this : new ByteArrayCharSequence(this.myChars, this.myStart + start2, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.myChars, this.myStart, this.length(), StandardCharsets.ISO_8859_1);
    }

    public void getChars(int start2, int end, char[] dest, int pos) {
        for (int idx = start2; idx < end; ++idx) {
            dest[idx - start2 + pos] = (char)(this.myChars[idx + this.myStart] & 0xFF);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "org/jetbrains/kotlin/com/intellij/util/text/ByteArrayCharSequence", "<init>"));
    }
}

