/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.diagnostic.ThreadDumper;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;

public final class EDT {
    private static Thread myEventDispatchThread;
    private static MethodHandle dispatchEventMethod;

    private EDT() {
    }

    @ApiStatus.Internal
    public static void updateEdt() {
        if (myEventDispatchThread != Thread.currentThread()) {
            myEventDispatchThread = Thread.currentThread();
        }
    }

    @ApiStatus.Internal
    public static boolean isEdt(@NotNull Thread thread) {
        if (thread == null) {
            EDT.$$$reportNull$$$0(0);
        }
        return thread == myEventDispatchThread;
    }

    @ApiStatus.Internal
    @NotNull
    public static Thread getEventDispatchThread() {
        Thread thread = myEventDispatchThread;
        if (thread == null) {
            EDT.$$$reportNull$$$0(1);
        }
        return thread;
    }

    public static boolean isCurrentThreadEdt() {
        return myEventDispatchThread == null ? EventQueue.isDispatchThread() : EDT.isEdt(Thread.currentThread());
    }

    public static void assertIsEdt() {
        if (!EDT.isCurrentThreadEdt()) {
            Logger.getInstance(EDT.class).error("Assert: must be called on EDT");
        }
    }

    @TestOnly
    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        EDT.assertIsEdt();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        MethodHandle dispatchEventMethod = EDT.dispatchEventMethod;
        if (dispatchEventMethod == null) {
            try {
                Method method = EventQueue.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                method.setAccessible(true);
                dispatchEventMethod = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException();
            }
            EDT.dispatchEventMethod = dispatchEventMethod;
        }
        boolean threadsDumped = false;
        int i2 = 1;
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (event instanceof InvocationEvent) {
                    dispatchEventMethod.bindTo(eventQueue).invoke(event);
                }
            }
            catch (Throwable e) {
                ExceptionUtilRt.rethrowUnchecked(e);
                throw new RuntimeException(e);
            }
            if (i2 % 10000 == 0) {
                System.out.println("Suspiciously many (" + i2 + ") AWT events, last dispatched " + event);
                if (!threadsDumped) {
                    threadsDumped = true;
                    try {
                        Object application = ReflectionUtil.getMethod(Class.forName("org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager"), "getApplication", new Class[0]).invoke(null, new Object[0]);
                        System.err.println("Application=" + application + "\n" + ThreadDumper.dumpThreadsToString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ++i2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/EDT";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/EDT";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDispatchThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEdt";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

