/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.ir.declarations;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.gradle.internal.descriptors.MultiFieldValueClassRepresentation;
import org.jetbrains.kotlin.gradle.internal.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.gradle.internal.descriptors.ValueClassRepresentation;
import org.jetbrains.kotlin.gradle.internal.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.gradle.internal.ir.ObsoleteDescriptorBasedAPI;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrClass;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrFile;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrFunction;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.gradle.internal.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.gradle.internal.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.gradle.internal.ir.types.IrSimpleType;
import org.jetbrains.kotlin.gradle.internal.name.FqName;
import org.jetbrains.kotlin.gradle.internal.name.Name;
import org.jetbrains.kotlin.gradle.internal.name.NameUtils;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000p\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a#\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\u0002H\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\u000e\u001a\u00020\u000b*\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010\u001a\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007\u001a\u001c\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007\u001a\u001c\u0010$\u001a\u00020\u000b*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0007\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\"\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\u0012*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\"\u0015\u0010\u0018\u001a\u00020\u0012*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015\"\u0015\u0010\u001a\u001a\u00020\u0012*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015\"\u0015\u0010'\u001a\u00020\u0006*\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\"\u0015\u0010)\u001a\u00020\u0006*\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010(\"\u001d\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\"\u001d\u0010/\u001a\n\u0012\u0004\u0012\u00020,\u0018\u000100*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u00063"}, d2={"copyAttributes", "D", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrAttributeContainer;", "other", "(Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;)Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "isSingleFieldValueClass", "", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "isMultiFieldValueClass", "addMember", "", "member", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrDeclaration;", "addAll", "members", "", "path", "", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrFile;", "getPath", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Ljava/lang/String;", "name", "getName", "nameWithPackage", "getNameWithPackage", "packagePartClassName", "getPackagePartClassName", "getIrValueParameter", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/gradle/internal/ir/declarations/IrFunction;", "parameter", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/ParameterDescriptor;", "index", "", "putDefault", "expressionBody", "Lorg/jetbrains/kotlin/gradle/internal/ir/expressions/IrExpressionBody;", "isStaticMethodOfClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isPropertyAccessor", "multiFieldValueClassRepresentation", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/MultiFieldValueClassRepresentation;", "Lorg/jetbrains/kotlin/gradle/internal/ir/types/IrSimpleType;", "getMultiFieldValueClassRepresentation", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/descriptors/MultiFieldValueClassRepresentation;", "inlineClassRepresentation", "Lorg/jetbrains/kotlin/gradle/internal/descriptors/InlineClassRepresentation;", "getInlineClassRepresentation", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "ir.tree"})
public final class IrDeclarationsKt {
    @NotNull
    public static final <D extends IrAttributeContainer> D copyAttributes(@NotNull D $this$copyAttributes, @Nullable IrAttributeContainer other) {
        D d;
        Intrinsics.checkNotNullParameter($this$copyAttributes, (String)"<this>");
        D $this$copyAttributes_u24lambda_u240 = d = $this$copyAttributes;
        boolean bl = false;
        if (other != null) {
            $this$copyAttributes_u24lambda_u240.setAttributeOwnerId(other.getAttributeOwnerId());
            $this$copyAttributes_u24lambda_u240.setOriginalBeforeInline(other.getOriginalBeforeInline());
        }
        return d;
    }

    public static final boolean isSingleFieldValueClass(@NotNull IrClass $this$isSingleFieldValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isSingleFieldValueClass, (String)"<this>");
        return $this$isSingleFieldValueClass.getValueClassRepresentation() instanceof InlineClassRepresentation;
    }

    public static final boolean isMultiFieldValueClass(@NotNull IrClass $this$isMultiFieldValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isMultiFieldValueClass, (String)"<this>");
        return $this$isMultiFieldValueClass.getValueClassRepresentation() instanceof MultiFieldValueClassRepresentation;
    }

    public static final void addMember(@NotNull IrClass $this$addMember, @NotNull IrDeclaration member) {
        Intrinsics.checkNotNullParameter((Object)$this$addMember, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        $this$addMember.getDeclarations().add(member);
    }

    public static final void addAll(@NotNull IrClass $this$addAll, @NotNull List<? extends IrDeclaration> members) {
        Intrinsics.checkNotNullParameter((Object)$this$addAll, (String)"<this>");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        $this$addAll.getDeclarations().addAll((Collection<IrDeclaration>)members);
    }

    @NotNull
    public static final String getPath(@NotNull IrFile $this$path) {
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        return $this$path.getFileEntry().getName();
    }

    @NotNull
    public static final String getName(@NotNull IrFile $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        String string2 = new File(IrDeclarationsKt.getPath($this$name)).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return string2;
    }

    @NotNull
    public static final String getNameWithPackage(@NotNull IrFile $this$nameWithPackage) {
        Intrinsics.checkNotNullParameter((Object)$this$nameWithPackage, (String)"<this>");
        FqName fqName = $this$nameWithPackage.getPackageFqName();
        Name name2 = Name.identifier(IrDeclarationsKt.getName($this$nameWithPackage));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        return fqName.child(name2).asString();
    }

    @NotNull
    public static final String getPackagePartClassName(@NotNull IrFile $this$packagePartClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$packagePartClassName, (String)"<this>");
        return NameUtils.getPackagePartClassNamePrefix(FilesKt.getNameWithoutExtension((File)new File(IrDeclarationsKt.getPath($this$packagePartClassName)))) + "Kt";
    }

    @ObsoleteDescriptorBasedAPI
    @NotNull
    public static final IrValueParameter getIrValueParameter(@NotNull IrFunction $this$getIrValueParameter, @NotNull ValueParameterDescriptor parameter) {
        Intrinsics.checkNotNullParameter((Object)$this$getIrValueParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return IrDeclarationsKt.getIrValueParameter($this$getIrValueParameter, parameter, parameter.getIndex());
    }

    @ObsoleteDescriptorBasedAPI
    @NotNull
    public static final IrValueParameter getIrValueParameter(@NotNull IrFunction $this$getIrValueParameter, @NotNull ParameterDescriptor parameter, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getIrValueParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Object object = $this$getIrValueParameter.getValueParameters();
        if (!(0 <= index ? index < object.size() : false)) {
            int it = index;
            boolean bl = false;
            throw new AssertionError((Object)("No IrValueParameter for " + parameter));
        }
        object = object.get(index);
        IrValueParameter found = (IrValueParameter)object;
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)found.getDescriptor(), (Object)parameter);
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string2 = "Parameter indices mismatch at " + $this$getIrValueParameter.getDescriptor() + ": " + parameter + " != " + found.getDescriptor();
            throw new AssertionError((Object)string2);
        }
        return (IrValueParameter)object;
    }

    @ObsoleteDescriptorBasedAPI
    public static final void putDefault(@NotNull IrFunction $this$putDefault, @NotNull ValueParameterDescriptor parameter, @NotNull IrExpressionBody expressionBody) {
        Intrinsics.checkNotNullParameter((Object)$this$putDefault, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)expressionBody, (String)"expressionBody");
        IrDeclarationsKt.getIrValueParameter($this$putDefault, parameter).setDefaultValue(expressionBody);
    }

    public static final boolean isStaticMethodOfClass(@NotNull IrFunction $this$isStaticMethodOfClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isStaticMethodOfClass, (String)"<this>");
        return $this$isStaticMethodOfClass instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isStaticMethodOfClass).getParent() instanceof IrClass && $this$isStaticMethodOfClass.getDispatchReceiverParameter() == null;
    }

    public static final boolean isPropertyAccessor(@NotNull IrFunction $this$isPropertyAccessor) {
        Intrinsics.checkNotNullParameter((Object)$this$isPropertyAccessor, (String)"<this>");
        return $this$isPropertyAccessor instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isPropertyAccessor).getCorrespondingPropertySymbol() != null;
    }

    @Nullable
    public static final MultiFieldValueClassRepresentation<IrSimpleType> getMultiFieldValueClassRepresentation(@NotNull IrClass $this$multiFieldValueClassRepresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$multiFieldValueClassRepresentation, (String)"<this>");
        ValueClassRepresentation<IrSimpleType> valueClassRepresentation = $this$multiFieldValueClassRepresentation.getValueClassRepresentation();
        return valueClassRepresentation instanceof MultiFieldValueClassRepresentation ? (MultiFieldValueClassRepresentation)valueClassRepresentation : null;
    }

    @Nullable
    public static final InlineClassRepresentation<IrSimpleType> getInlineClassRepresentation(@NotNull IrClass $this$inlineClassRepresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$inlineClassRepresentation, (String)"<this>");
        ValueClassRepresentation<IrSimpleType> valueClassRepresentation = $this$inlineClassRepresentation.getValueClassRepresentation();
        return valueClassRepresentation instanceof InlineClassRepresentation ? (InlineClassRepresentation)valueClassRepresentation : null;
    }
}

