/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.ide.dependencyResolvers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.KonanDistribution;
import org.jetbrains.kotlin.commonizer.KonanDistributionKt;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinBinaryCoordinates;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinBinaryDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinClasspathKt;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinResolvedBinaryDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.extras.KlibExtra;
import org.jetbrains.kotlin.gradle.idea.tcs.extras.KlibExtraKt;
import org.jetbrains.kotlin.gradle.idea.tcs.extras.PrimitiveExtrasKt;
import org.jetbrains.kotlin.gradle.idea.tcs.extras.SourcesAndDocumentationExtrasKt;
import org.jetbrains.kotlin.gradle.internal.properties.NativePropertiesKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.ide.FactoriesKt;
import org.jetbrains.kotlin.gradle.plugin.ide.IdeDependencyResolver;
import org.jetbrains.kotlin.gradle.utils.ProjectExtensionsKt;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/ide/dependencyResolvers/IdeNativeStdlibDependencyResolver;", "Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeDependencyResolver;", "()V", "nativeStdlibCoordinates", "Lorg/jetbrains/kotlin/gradle/idea/tcs/IdeaKotlinBinaryCoordinates;", "project", "Lorg/gradle/api/Project;", "resolve", "", "Lorg/jetbrains/kotlin/gradle/idea/tcs/IdeaKotlinDependency;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nIdeNativeStdlibDependencyResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeNativeStdlibDependencyResolver.kt\norg/jetbrains/kotlin/gradle/plugin/ide/dependencyResolvers/IdeNativeStdlibDependencyResolver\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n18#2:65\n3829#3:66\n4344#3,2:67\n1#4:69\n*S KotlinDebug\n*F\n+ 1 IdeNativeStdlibDependencyResolver.kt\norg/jetbrains/kotlin/gradle/plugin/ide/dependencyResolvers/IdeNativeStdlibDependencyResolver\n*L\n50#1:65\n52#1:66\n52#1:67,2\n*E\n"})
public final class IdeNativeStdlibDependencyResolver
implements IdeDependencyResolver {
    @NotNull
    public static final IdeNativeStdlibDependencyResolver INSTANCE = new IdeNativeStdlibDependencyResolver();

    private IdeNativeStdlibDependencyResolver() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<IdeaKotlinDependency> resolve(@NotNull KotlinSourceSet sourceSet) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        File[] fileArray;
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        KonanDistribution konanDistribution2 = ProjectExtensionsKt.getKonanDistribution(sourceSet.getProject());
        File stdlibFile = KonanDistributionKt.getStdlib((KonanDistribution)konanDistribution2);
        try {
            String string2 = stdlibFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stdlibFile.absolutePath");
            KotlinLibrary kotlinLibrary = SingleFileResolveKt.resolveSingleFileKlib$default((org.jetbrains.kotlin.konan.file.File)new org.jetbrains.kotlin.konan.file.File(string2), null, (SingleFileKlibResolveStrategy)((SingleFileKlibResolveStrategy)ToolingSingleFileKlibResolveStrategy.INSTANCE), (int)2, null);
            fileArray = FactoriesKt.KlibExtra(kotlinLibrary);
        }
        catch (Throwable error) {
            fileArray = null;
        }
        File[] klibExtra = fileArray;
        fileArray = new File[]{stdlibFile};
        File[] $this$resolve_u24lambda_u242 = fileArray = new IdeaKotlinResolvedBinaryDependency("KOTLIN_COMPILE", IdeaKotlinClasspathKt.IdeaKotlinClasspath((File[])fileArray), this.nativeStdlibCoordinates(sourceSet.getProject()), null, 8, null);
        boolean bl = false;
        PrimitiveExtrasKt.setNativeDistribution((IdeaKotlinBinaryDependency)((IdeaKotlinBinaryDependency)$this$resolve_u24lambda_u242), (boolean)true);
        PrimitiveExtrasKt.setNativeStdlib((IdeaKotlinBinaryDependency)((IdeaKotlinBinaryDependency)$this$resolve_u24lambda_u242), (boolean)true);
        KlibExtraKt.setKlibExtra((IdeaKotlinBinaryDependency)((IdeaKotlinBinaryDependency)$this$resolve_u24lambda_u242), (KlibExtra)klibExtra);
        Collection collection = (Collection)SourcesAndDocumentationExtrasKt.getSourcesClasspath((IdeaKotlinBinaryDependency)((IdeaKotlinBinaryDependency)$this$resolve_u24lambda_u242));
        File[] $this$orEmpty$iv = KonanDistributionKt.getSourcesDir((KonanDistribution)konanDistribution2).listFiles();
        boolean $i$f$orEmpty = false;
        File[] fileArray2 = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            fileArray2 = new File[]{};
        }
        $this$orEmpty$iv = fileArray2;
        boolean $i$f$filter = false;
        void var11_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void file2 = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl2 = false;
            String string3 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
            if (!StringsKt.startsWith$default((String)string3, (String)"kotlin", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable = (List)destination$iv$iv;
        if (iterable.isEmpty()) {
            boolean bl3 = false;
            return SetsKt.emptySet();
        }
        iterable = iterable;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return SetsKt.setOf((Object)fileArray);
    }

    @NotNull
    public final IdeaKotlinBinaryCoordinates nativeStdlibCoordinates(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new IdeaKotlinBinaryCoordinates("org.jetbrains.kotlin.native", "stdlib", (String)NativePropertiesKt.getNativeProperties(project).getKotlinNativeVersion().get(), null, 8, null);
    }
}

