/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.attributes.Usage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.PreparedKotlinToolingDiagnosticsCollector;
import org.jetbrains.kotlin.gradle.plugin.mpp.IMppDependenciesProjectStructureMetadataExtractorFactory;
import org.jetbrains.kotlin.gradle.plugin.mpp.JarMppDependencyProjectStructureMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.MppDependencyProjectStructureMetadataExtractor;
import org.jetbrains.kotlin.gradle.plugin.mpp.ProjectMppDependencyProjectStructureMetadataExtractor;
import org.jetbrains.kotlin.gradle.utils.CurrentBuildIdentifier;
import org.jetbrains.kotlin.gradle.utils.CurrentBuildIdentifierKt;
import org.jetbrains.kotlin.gradle.utils.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.utils.LazyResolvedConfiguration;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependenciesProjectStructureMetadataExtractorFactory;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/IMppDependenciesProjectStructureMetadataExtractorFactory;", "currentBuild", "Lorg/jetbrains/kotlin/gradle/utils/CurrentBuildIdentifier;", "(Lorg/jetbrains/kotlin/gradle/utils/CurrentBuildIdentifier;)V", "create", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependencyProjectStructureMetadataExtractor;", "metadataArtifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "dependency", "Lorg/gradle/api/artifacts/result/ResolvedDependencyResult;", "diagnosticsCollector", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/PreparedKotlinToolingDiagnosticsCollector;", "resolvedPsmConfiguration", "Lorg/jetbrains/kotlin/gradle/utils/LazyResolvedConfiguration;", "findPsmFileOrNull", "Ljava/io/File;", "moduleId", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nMppDependenciesProjectStructureMetadataExtractorFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MppDependenciesProjectStructureMetadataExtractorFactory.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/MppDependenciesProjectStructureMetadataExtractorFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1#2:96\n774#3:97\n865#3,2:98\n1557#3:100\n1628#3,3:101\n*S KotlinDebug\n*F\n+ 1 MppDependenciesProjectStructureMetadataExtractorFactory.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/MppDependenciesProjectStructureMetadataExtractorFactory\n*L\n84#1:97\n84#1:98,2\n85#1:100\n85#1:101,3\n*E\n"})
public final class MppDependenciesProjectStructureMetadataExtractorFactory
implements IMppDependenciesProjectStructureMetadataExtractorFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CurrentBuildIdentifier currentBuild;

    private MppDependenciesProjectStructureMetadataExtractorFactory(CurrentBuildIdentifier currentBuild2) {
        this.currentBuild = currentBuild2;
    }

    @Override
    @Nullable
    public MppDependencyProjectStructureMetadataExtractor create(@NotNull ResolvedArtifactResult metadataArtifact, @NotNull ResolvedDependencyResult dependency, @NotNull PreparedKotlinToolingDiagnosticsCollector diagnosticsCollector, @Nullable LazyResolvedConfiguration resolvedPsmConfiguration) {
        Intrinsics.checkNotNullParameter((Object)metadataArtifact, (String)"metadataArtifact");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)diagnosticsCollector, (String)"diagnosticsCollector");
        if (resolvedPsmConfiguration == null) {
            boolean $i$a$-checkNotNull-MppDependenciesProjectStructureMetadataExtractorFactory$create$22 = false;
            String $i$a$-checkNotNull-MppDependenciesProjectStructureMetadataExtractorFactory$create$22 = "MppDependenciesProjectStructureMetadataExtractorFactory must not receive null psmConfiguration";
            throw new IllegalStateException($i$a$-checkNotNull-MppDependenciesProjectStructureMetadataExtractorFactory$create$22.toString());
        }
        ComponentIdentifier moduleId2 = metadataArtifact.getVariant().getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)moduleId2, (String)"moduleId");
        File psmFile = this.findPsmFileOrNull(resolvedPsmConfiguration, moduleId2);
        if (psmFile == null && moduleId2 instanceof ProjectComponentIdentifier && !this.currentBuild.contains(moduleId2)) {
            diagnosticsCollector.report(KotlinToolingDiagnostics.ProjectIsolationIncompatibleWithIncludedBuildsWithOldKotlinVersion.INSTANCE.invoke(dependency.getRequested().toString(), GradleUtilsKt.getBuildTreePathCompat((ProjectComponentIdentifier)moduleId2)), true, dependency.getRequested().toString());
            return null;
        }
        if (psmFile == null && moduleId2 instanceof ProjectComponentIdentifier && this.currentBuild.contains(moduleId2)) {
            throw new IllegalStateException(("Project structure metadata not found for project '" + ((ProjectComponentIdentifier)moduleId2).getProjectPath() + '\'').toString());
        }
        if (psmFile == null) {
            File file2 = metadataArtifact.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"metadataArtifact.file");
            return new JarMppDependencyProjectStructureMetadataExtractor(file2);
        }
        return new ProjectMppDependencyProjectStructureMetadataExtractor(psmFile);
    }

    /*
     * WARNING - void declaration
     */
    private final File findPsmFileOrNull(LazyResolvedConfiguration resolvedPsmConfiguration, ComponentIdentifier moduleId2) {
        void $this$mapTo$iv$iv;
        ResolvedArtifactResult it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = resolvedPsmConfiguration.getArtifacts(moduleId2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResolvedArtifactResult)element$iv$iv;
            boolean bl = false;
            Usage usage2 = (Usage)it.getVariant().getAttributes().getAttribute(Usage.USAGE_ATTRIBUTE);
            if (!Intrinsics.areEqual((Object)(usage2 != null ? usage2.getName() : null), (Object)"kotlin-psm-metadata")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResolvedArtifactResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (File)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
    }

    public /* synthetic */ MppDependenciesProjectStructureMetadataExtractorFactory(CurrentBuildIdentifier currentBuild2, DefaultConstructorMarker $constructor_marker) {
        this(currentBuild2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependenciesProjectStructureMetadataExtractorFactory$Companion;", "", "()V", "getOrCreate", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/MppDependenciesProjectStructureMetadataExtractorFactory;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MppDependenciesProjectStructureMetadataExtractorFactory getOrCreate(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new MppDependenciesProjectStructureMetadataExtractorFactory(CurrentBuildIdentifierKt.getCurrentBuild(project), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

