/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnostics;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.KotlinToolingDiagnosticsCollector;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.ToolingDiagnostic;
import org.jetbrains.kotlin.gradle.plugin.diagnostics.UsesKotlinToolingDiagnostics;

@DisableCachingByDefault(because="We are checking only file permissions")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b!\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/CheckSandboxAndWriteProtectionTask;", "Lorg/gradle/api/DefaultTask;", "Lorg/jetbrains/kotlin/gradle/plugin/diagnostics/UsesKotlinToolingDiagnostics;", "()V", "builtProductsDir", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getBuiltProductsDir", "()Lorg/gradle/api/provider/Property;", "userScriptSandboxingEnabled", "", "getUserScriptSandboxingEnabled", "builtProductsDirAccessibility", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/CheckSandboxAndWriteProtectionTask$DirAccessibility;", "checkSandboxAndWriteProtection", "", "fireSandboxDiagnostic", "DirAccessibility", "kotlin-gradle-plugin_common"})
public abstract class CheckSandboxAndWriteProtectionTask
extends DefaultTask
implements UsesKotlinToolingDiagnostics {
    @Input
    @NotNull
    public abstract Property<File> getBuiltProductsDir();

    @Input
    @NotNull
    public abstract Property<Boolean> getUserScriptSandboxingEnabled();

    @TaskAction
    public final void checkSandboxAndWriteProtection() {
        DirAccessibility dirAccessible = this.builtProductsDirAccessibility((File)this.getBuiltProductsDir().getOrNull());
        Boolean sandboxingEnabled = (Boolean)this.getUserScriptSandboxingEnabled().get();
        switch (WhenMappings.$EnumSwitchMapping$0[dirAccessible.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNullExpressionValue((Object)sandboxingEnabled, (String)"sandboxingEnabled");
                this.fireSandboxDiagnostic(sandboxingEnabled);
                break;
            }
            case 2: 
            case 3: {
                Intrinsics.checkNotNullExpressionValue((Object)sandboxingEnabled, (String)"sandboxingEnabled");
                if (!sandboxingEnabled.booleanValue()) break;
                this.fireSandboxDiagnostic(true);
            }
        }
    }

    private final DirAccessibility builtProductsDirAccessibility(File builtProductsDir2) {
        DirAccessibility dirAccessibility;
        if (builtProductsDir2 != null) {
            DirAccessibility dirAccessibility2;
            try {
                Files.createDirectories(builtProductsDir2.toPath(), new FileAttribute[0]);
                File tempFile = File.createTempFile("sandbox", ".tmp", builtProductsDir2);
                if (tempFile.exists()) {
                    tempFile.delete();
                }
                dirAccessibility2 = DirAccessibility.ACCESSIBLE;
            }
            catch (IOException e) {
                dirAccessibility2 = DirAccessibility.NOT_ACCESSIBLE;
            }
            dirAccessibility = dirAccessibility2;
        } else {
            dirAccessibility = DirAccessibility.DOES_NOT_EXIST;
        }
        return dirAccessibility;
    }

    private final void fireSandboxDiagnostic(boolean userScriptSandboxingEnabled) {
        Object object = this.getToolingDiagnosticsCollector().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toolingDiagnosticsCollector.get()");
        KotlinToolingDiagnosticsCollector.report$default((KotlinToolingDiagnosticsCollector)object, this, KotlinToolingDiagnostics.XcodeUserScriptSandboxingDiagnostic.INSTANCE.invoke(userScriptSandboxingEnabled), false, null, 12, null);
    }

    @Override
    public void reportDiagnostic(@NotNull ToolingDiagnostic diagnostic) {
        UsesKotlinToolingDiagnostics.DefaultImpls.reportDiagnostic(this, diagnostic);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/CheckSandboxAndWriteProtectionTask$DirAccessibility;", "", "(Ljava/lang/String;I)V", "ACCESSIBLE", "NOT_ACCESSIBLE", "DOES_NOT_EXIST", "kotlin-gradle-plugin_common"})
    private static final class DirAccessibility
    extends Enum<DirAccessibility> {
        public static final /* enum */ DirAccessibility ACCESSIBLE = new DirAccessibility();
        public static final /* enum */ DirAccessibility NOT_ACCESSIBLE = new DirAccessibility();
        public static final /* enum */ DirAccessibility DOES_NOT_EXIST = new DirAccessibility();
        private static final /* synthetic */ DirAccessibility[] $VALUES;

        public static DirAccessibility[] values() {
            return (DirAccessibility[])$VALUES.clone();
        }

        public static DirAccessibility valueOf(String value2) {
            return Enum.valueOf(DirAccessibility.class, value2);
        }

        static {
            $VALUES = dirAccessibilityArray = new DirAccessibility[]{DirAccessibility.ACCESSIBLE, DirAccessibility.NOT_ACCESSIBLE, DirAccessibility.DOES_NOT_EXIST};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DirAccessibility.values().length];
            try {
                nArray[DirAccessibility.NOT_ACCESSIBLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DirAccessibility.DOES_NOT_EXIST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DirAccessibility.ACCESSIBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

