/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.testing;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.process.ProcessForkOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.ExperimentalWasmDsl;
import org.jetbrains.kotlin.gradle.internal.testing.TCServiceMessagesClientSettings;
import org.jetbrains.kotlin.gradle.internal.testing.TCServiceMessagesTestExecutionSpec;
import org.jetbrains.kotlin.gradle.targets.js.RequiredKotlinJsDependency;
import org.jetbrains.kotlin.gradle.targets.js.UtilsKt;
import org.jetbrains.kotlin.gradle.targets.js.d8.D8EnvSpec;
import org.jetbrains.kotlin.gradle.targets.js.d8.D8Plugin;
import org.jetbrains.kotlin.gradle.targets.js.ir.KotlinJsIrCompilation;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectKt;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinJsTest;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinJsTestFramework;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinTestRunnerCliArgs;
import org.jetbrains.kotlin.gradle.targets.js.testing.KotlinWasmD8;

@ExperimentalWasmDsl
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinWasmD8;", "Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinJsTestFramework;", "kotlinJsTest", "Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinJsTest;", "(Lorg/jetbrains/kotlin/gradle/targets/js/testing/KotlinJsTest;)V", "compilation", "Lorg/jetbrains/kotlin/gradle/targets/js/ir/KotlinJsIrCompilation;", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/targets/js/ir/KotlinJsIrCompilation;", "d8", "Lorg/jetbrains/kotlin/gradle/targets/js/d8/D8EnvSpec;", "d8Executable", "Lorg/gradle/api/provider/Provider;", "", "kotlin.jvm.PlatformType", "requiredNpmDependencies", "", "Lorg/jetbrains/kotlin/gradle/targets/js/RequiredKotlinJsDependency;", "getRequiredNpmDependencies", "()Ljava/util/Set;", "settingsState", "getSettingsState", "()Ljava/lang/String;", "testPath", "workingDir", "Lorg/gradle/api/file/Directory;", "getWorkingDir", "()Lorg/gradle/api/provider/Provider;", "createTestExecutionSpec", "Lorg/jetbrains/kotlin/gradle/internal/testing/TCServiceMessagesTestExecutionSpec;", "task", "forkOptions", "Lorg/gradle/process/ProcessForkOptions;", "nodeJsArgs", "", "debug", "", "getPath", "kotlin-gradle-plugin_common"})
public final class KotlinWasmD8
implements KotlinJsTestFramework {
    @NotNull
    private final String settingsState;
    @NotNull
    private final String testPath;
    @NotNull
    private final transient KotlinJsIrCompilation compilation;
    @NotNull
    private final D8EnvSpec d8;
    private final Provider<String> d8Executable;
    @NotNull
    private final Provider<Directory> workingDir;
    @NotNull
    private final Set<RequiredKotlinJsDependency> requiredNpmDependencies;

    public KotlinWasmD8(@NotNull KotlinJsTest kotlinJsTest) {
        Intrinsics.checkNotNullParameter((Object)kotlinJsTest, (String)"kotlinJsTest");
        this.settingsState = "KotlinWasmD8";
        this.testPath = kotlinJsTest.getPath();
        this.compilation = kotlinJsTest.getCompilation();
        Project project = kotlinJsTest.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"kotlinJsTest.project");
        this.d8 = D8Plugin.Companion.applyWithEnvSpec$kotlin_gradle_plugin_common(project);
        ProviderFactory providerFactory = this.getCompilation().getProject().getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"compilation.project.providers");
        this.d8Executable = this.d8.produceEnv$kotlin_gradle_plugin_common(providerFactory).map((Transformer)d8Executable.1.INSTANCE);
        this.workingDir = NpmProjectKt.getNpmProject(this.getCompilation()).getDir();
        this.requiredNpmDependencies = SetsKt.emptySet();
    }

    @Override
    @NotNull
    public String getSettingsState() {
        return this.settingsState;
    }

    @Override
    @NotNull
    public KotlinJsIrCompilation getCompilation() {
        return this.compilation;
    }

    @Override
    @NotNull
    public Provider<Directory> getWorkingDir() {
        return this.workingDir;
    }

    @Override
    @NotNull
    public TCServiceMessagesTestExecutionSpec createTestExecutionSpec(@NotNull KotlinJsTest task2, @NotNull ProcessForkOptions forkOptions, @NotNull List<String> nodeJsArgs, boolean debug) {
        List args2;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)forkOptions, (String)"forkOptions");
        Intrinsics.checkNotNullParameter(nodeJsArgs, (String)"nodeJsArgs");
        File compiledFile = ((RegularFile)task2.getInputFileProperty().get()).getAsFile();
        File file2 = ((Directory)this.getWorkingDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"workingDir.get().asFile");
        Intrinsics.checkNotNullExpressionValue((Object)compiledFile, (String)"compiledFile");
        File testRunnerFile = UtilsKt.writeWasmUnitTestRunner(file2, compiledFile);
        forkOptions.setExecutable((String)this.d8Executable.get());
        forkOptions.setWorkingDir(compiledFile.getParentFile());
        String string2 = task2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.name");
        TCServiceMessagesClientSettings clientSettings2 = new TCServiceMessagesClientSettings(string2, task2.getTargetName(), true, false, createTestExecutionSpec.clientSettings.1.INSTANCE, true, false, 72, null);
        KotlinTestRunnerCliArgs cliArgs = new KotlinTestRunnerCliArgs(null, task2.getIncludePatterns(), task2.getExcludePatterns(), null, 9, null);
        List $this$createTestExecutionSpec_u24lambda_u240 = args2 = (List)new ArrayList();
        boolean bl = false;
        String string3 = testRunnerFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"testRunnerFile.absolutePath");
        $this$createTestExecutionSpec_u24lambda_u240.add(string3);
        $this$createTestExecutionSpec_u24lambda_u240.add("--");
        $this$createTestExecutionSpec_u24lambda_u240.addAll((Collection)cliArgs.toList());
        return new TCServiceMessagesTestExecutionSpec(forkOptions, args2, false, clientSettings2, CollectionsKt.plus((Collection)args2, (Object)"--dryRun"));
    }

    @Override
    @NotNull
    public Set<RequiredKotlinJsDependency> getRequiredNpmDependencies() {
        return this.requiredNpmDependencies;
    }

    @Override
    @NotNull
    public String getPath() {
        return this.testPath + ":kotlinTestFrameworkStub";
    }
}

