/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats;

import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatConsumer;

public interface FloatIterator
extends PrimitiveIterator<Float, FloatConsumer> {
    public float nextFloat();

    @Override
    @Deprecated
    default public Float next() {
        return Float.valueOf(this.nextFloat());
    }

    @Override
    default public void forEachRemaining(FloatConsumer action2) {
        Objects.requireNonNull(action2);
        while (this.hasNext()) {
            action2.accept(this.nextFloat());
        }
    }

    @Override
    default public void forEachRemaining(DoubleConsumer action2) {
        Objects.requireNonNull(action2);
        this.forEachRemaining(action2 instanceof FloatConsumer ? (FloatConsumer)action2 : action2::accept);
    }

    @Override
    @Deprecated
    default public void forEachRemaining(Consumer<? super Float> action2) {
        this.forEachRemaining(action2 instanceof FloatConsumer ? (FloatConsumer)action2 : action2::accept);
    }

    default public int skip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument must be nonnegative: " + n);
        }
        int i2 = n;
        while (i2-- != 0 && this.hasNext()) {
            this.nextFloat();
        }
        return n - i2 - 1;
    }
}

