/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerLoggerAdapterKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocationWithRange;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.gradle.internal.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.gradle.internal.config.CompilerConfiguration;
import org.jetbrains.kotlin.gradle.internal.config.IncrementalCompilation;
import org.jetbrains.kotlin.gradle.internal.name.FqName;
import org.jetbrains.kotlin.gradle.internal.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.util.Logger;

@Metadata(k=2, mv={2, 0, 0}, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0004\u001a[\u0010\u0012\u001a\u00020\u0002\"\u0004\b\u0000\u0010\u00062\u0006\u0010\b\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\r2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00100\r\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a-\u0010\u0015\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a-\u0010\u0018\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0018\u0010\u0016\u001a\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001b*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a+\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0018\u00010 *\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"\u001a'\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0 *\u00020#2\u0006\u0010$\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b%\u0010&\u001aO\u0010/\u001a\u0004\u0018\u00010*\"\b\b\u0000\u0010(*\u00020'2\b\u0010)\u001a\u0004\u0018\u00018\u00002\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020*0\r2\u0006\u0010-\u001a\u00020,2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020,\u00a2\u0006\u0004\b/\u00100\u001a\u0013\u00102\u001a\u000201*\u00020\u000bH\u0007\u00a2\u0006\u0004\b2\u00103\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "arguments", "", "incrementalCompilationIsEnabled", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Z", "incrementalCompilationIsEnabledForJs", "F", "Lorg/jetbrains/kotlin/gradle/internal/config/CompilerConfiguration;", "configuration", "", "files", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "messageCollector", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "getPackage", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "getMessageLocation", "checkKotlinPackageUsage", "(Lorg/jetbrains/kotlin/gradle/internal/config/CompilerConfiguration;Ljava/util/Collection;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Z", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkKotlinPackageUsageForPsi", "(Lorg/jetbrains/kotlin/gradle/internal/config/CompilerConfiguration;Ljava/util/Collection;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "checkKotlinPackageUsageForLightTree", "Lorg/jetbrains/kotlin/KtSourceElement;", "file", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocationWithRange;", "getLocationWithin", "(Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/declarations/FirFile;)Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocationWithRange;", "", "offset", "Lkotlin/Pair;", "getLineAndColumnStartingWithOnesAt", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Integer;)Lkotlin/Pair;", "Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;", "startOffset", "getLineAndColumnByOffsetStartingWithOnes", "(Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;I)Lkotlin/Pair;", "", "PathProvider", "paths", "Ljava/io/File;", "getLibrary", "", "libraryName", "noLibraryArgument", "getLibraryFromHome", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/lang/String;)Ljava/io/File;", "Lorg/jetbrains/kotlin/gradle/internal/util/Logger;", "toLogger", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)Lorg/jetbrains/kotlin/gradle/internal/util/Logger;", "cli"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/cli/common/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class UtilsKt {
    public static final boolean incrementalCompilationIsEnabled(@NotNull CommonCompilerArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Boolean bl = arguments.getIncrementalCompilation();
        return bl != null ? bl : IncrementalCompilation.isEnabledForJvm();
    }

    public static final boolean incrementalCompilationIsEnabledForJs(@NotNull CommonCompilerArguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Boolean bl = arguments.getIncrementalCompilation();
        return bl != null ? bl : IncrementalCompilation.isEnabledForJs();
    }

    public static final <F> boolean checkKotlinPackageUsage(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends F> files2, @NotNull MessageCollector messageCollector, @NotNull Function1<? super F, FqName> getPackage, @NotNull Function1<? super F, ? extends CompilerMessageSourceLocation> getMessageLocation) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter(getPackage, (String)"getPackage");
        Intrinsics.checkNotNullParameter(getMessageLocation, (String)"getMessageLocation");
        if (configuration2.getBoolean(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE)) {
            return true;
        }
        FqName kotlinPackage = new FqName("kotlin");
        for (F file2 : files2) {
            if (!FqNamesUtilKt.isSubpackageOf((FqName)getPackage.invoke(file2), kotlinPackage)) continue;
            messageCollector.report(CompilerMessageSeverity.ERROR, "Only the Kotlin standard library is allowed to use the 'kotlin' package", (CompilerMessageSourceLocation)getMessageLocation.invoke(file2));
            return false;
        }
        return true;
    }

    public static final boolean checkKotlinPackageUsageForPsi(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends KtFile> files2, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        return UtilsKt.checkKotlinPackageUsage(configuration2, files2, messageCollector, UtilsKt::checkKotlinPackageUsageForPsi$lambda$0, UtilsKt::checkKotlinPackageUsageForPsi$lambda$1);
    }

    public static /* synthetic */ boolean checkKotlinPackageUsageForPsi$default(CompilerConfiguration compilerConfiguration, Collection collection, MessageCollector messageCollector, int n, Object object) {
        if ((n & 4) != 0) {
            messageCollector = CommonConfigurationKeysKt.getMessageCollector(compilerConfiguration);
        }
        return UtilsKt.checkKotlinPackageUsageForPsi(compilerConfiguration, collection, messageCollector);
    }

    public static final boolean checkKotlinPackageUsageForLightTree(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends FirFile> files2, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        return UtilsKt.checkKotlinPackageUsage(configuration2, files2, messageCollector, UtilsKt::checkKotlinPackageUsageForLightTree$lambda$2, UtilsKt::checkKotlinPackageUsageForLightTree$lambda$3);
    }

    public static /* synthetic */ boolean checkKotlinPackageUsageForLightTree$default(CompilerConfiguration compilerConfiguration, Collection collection, MessageCollector messageCollector, int n, Object object) {
        if ((n & 4) != 0) {
            messageCollector = CommonConfigurationKeysKt.getMessageCollector(compilerConfiguration);
        }
        return UtilsKt.checkKotlinPackageUsageForLightTree(compilerConfiguration, collection, messageCollector);
    }

    private static final CompilerMessageLocationWithRange getLocationWithin(KtSourceElement $this$getLocationWithin, FirFile file2) {
        KtSourceFile ktSourceFile = file2.getSourceFile();
        if (ktSourceFile == null) {
            return null;
        }
        KtSourceFile sourceFile = ktSourceFile;
        Pair<Integer, Integer> pair = UtilsKt.getLineAndColumnStartingWithOnesAt(file2, $this$getLocationWithin.getStartOffset());
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> pair2 = pair;
        int startLine = ((Number)pair2.component1()).intValue();
        int startColumn = ((Number)pair2.component2()).intValue();
        Pair<Integer, Integer> pair3 = UtilsKt.getLineAndColumnStartingWithOnesAt(file2, $this$getLocationWithin.getEndOffset());
        if (pair3 == null) {
            return null;
        }
        Pair<Integer, Integer> pair4 = pair3;
        int endLine = ((Number)pair4.component1()).intValue();
        int endColumn = ((Number)pair4.component2()).intValue();
        CharSequence charSequence = KtSourceElementKt.getText((KtSourceElement)$this$getLocationWithin);
        return CompilerMessageLocationWithRange.Companion.create(sourceFile.getPath(), startLine, startColumn, endLine, endColumn, charSequence != null ? ((Object)charSequence).toString() : null);
    }

    private static final Pair<Integer, Integer> getLineAndColumnStartingWithOnesAt(FirFile $this$getLineAndColumnStartingWithOnesAt, Integer offset) {
        Object object;
        Integer n = offset;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            KtSourceFileLinesMapping ktSourceFileLinesMapping = $this$getLineAndColumnStartingWithOnesAt.getSourceFileLinesMapping();
            object = ktSourceFileLinesMapping != null ? UtilsKt.getLineAndColumnByOffsetStartingWithOnes(ktSourceFileLinesMapping, it) : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final Pair<Integer, Integer> getLineAndColumnByOffsetStartingWithOnes(KtSourceFileLinesMapping $this$getLineAndColumnByOffsetStartingWithOnes, int startOffset) {
        Pair pair = $this$getLineAndColumnByOffsetStartingWithOnes.getLineAndColumnByOffset(startOffset);
        int line = ((Number)pair.component1()).intValue();
        int column = ((Number)pair.component2()).intValue();
        return TuplesKt.to((Object)(line + 1), (Object)(column + 1));
    }

    @Nullable
    public static final <PathProvider> File getLibraryFromHome(@Nullable PathProvider paths, @NotNull Function1<? super PathProvider, ? extends File> getLibrary, @NotNull String libraryName2, @NotNull MessageCollector messageCollector, @NotNull String noLibraryArgument) {
        File stdlibJar;
        Intrinsics.checkNotNullParameter(getLibrary, (String)"getLibrary");
        Intrinsics.checkNotNullParameter((Object)libraryName2, (String)"libraryName");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)noLibraryArgument, (String)"noLibraryArgument");
        if (paths != null && (stdlibJar = (File)getLibrary.invoke(paths)).exists()) {
            return stdlibJar;
        }
        messageCollector.report(CompilerMessageSeverity.STRONG_WARNING, "Unable to find " + libraryName2 + " in the Kotlin home directory. Pass either " + noLibraryArgument + " to prevent adding it to the classpath, or the correct '-kotlin-home'", null);
        return null;
    }

    @Deprecated(message="Use org.jetbrains.kotlin.cli.common.messages.toLogger() instead", replaceWith=@ReplaceWith(expression="toLogger()", imports={"org.jetbrains.kotlin.cli.common.messages.toLogger"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final Logger toLogger(@NotNull MessageCollector $this$toLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$toLogger, (String)"<this>");
        return CompilerLoggerAdapterKt.toLogger$default($this$toLogger, false, 1, null);
    }

    private static final FqName checkKotlinPackageUsageForPsi$lambda$0(KtFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPackageFqName();
    }

    private static final CompilerMessageSourceLocation checkKotlinPackageUsageForPsi$lambda$1(KtFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KtPackageDirective ktPackageDirective = it.getPackageDirective();
        Intrinsics.checkNotNull((Object)ktPackageDirective);
        return MessageUtil.psiElementToMessageLocation((PsiElement)((PsiElement)ktPackageDirective));
    }

    private static final FqName checkKotlinPackageUsageForLightTree$lambda$2(FirFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return org.jetbrains.kotlin.fir.UtilsKt.getPackageFqName((FirFile)it);
    }

    private static final CompilerMessageSourceLocation checkKotlinPackageUsageForLightTree$lambda$3(FirFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KtSourceElement ktSourceElement = it.getPackageDirective().getSource();
        return ktSourceElement != null ? UtilsKt.getLocationWithin(ktSourceElement, it) : null;
    }
}

