/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.util.concurrent;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.annotations.J2ktIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jetbrains.kotlin.com.google.errorprone.annotations.concurrent.LazyInit;

@ElementTypesAreNonnullByDefault
@GwtCompatible
@J2ktIncompatible
public final class AtomicLongMap<K>
implements Serializable {
    private final ConcurrentHashMap<K, Long> map;
    @LazyInit
    @CheckForNull
    private transient Map<K, Long> asMap;

    private AtomicLongMap(ConcurrentHashMap<K, Long> map2) {
        this.map = Preconditions.checkNotNull(map2);
    }

    public static <K> AtomicLongMap<K> create() {
        return new AtomicLongMap(new ConcurrentHashMap());
    }

    public static <K> AtomicLongMap<K> create(Map<? extends K, ? extends Long> m) {
        AtomicLongMap<? extends K> result2 = AtomicLongMap.create();
        result2.putAll(m);
        return result2;
    }

    public long get(K key) {
        return this.map.getOrDefault(key, 0L);
    }

    @CanIgnoreReturnValue
    public long incrementAndGet(K key) {
        return this.addAndGet(key, 1L);
    }

    @CanIgnoreReturnValue
    public long decrementAndGet(K key) {
        return this.addAndGet(key, -1L);
    }

    @CanIgnoreReturnValue
    public long addAndGet(K key, long delta) {
        return this.accumulateAndGet(key, delta, Long::sum);
    }

    @CanIgnoreReturnValue
    public long getAndIncrement(K key) {
        return this.getAndAdd(key, 1L);
    }

    @CanIgnoreReturnValue
    public long getAndDecrement(K key) {
        return this.getAndAdd(key, -1L);
    }

    @CanIgnoreReturnValue
    public long getAndAdd(K key, long delta) {
        return this.getAndAccumulate(key, delta, Long::sum);
    }

    @CanIgnoreReturnValue
    public long updateAndGet(K key, LongUnaryOperator updaterFunction) {
        Preconditions.checkNotNull(updaterFunction);
        Long result2 = this.map.compute(key, (k, value2) -> updaterFunction.applyAsLong(value2 == null ? 0L : value2));
        return Objects.requireNonNull(result2);
    }

    @CanIgnoreReturnValue
    public long getAndUpdate(K key, LongUnaryOperator updaterFunction) {
        Preconditions.checkNotNull(updaterFunction);
        AtomicLong holder = new AtomicLong();
        this.map.compute(key, (k, value2) -> {
            long oldValue = value2 == null ? 0L : value2;
            holder.set(oldValue);
            return updaterFunction.applyAsLong(oldValue);
        });
        return holder.get();
    }

    @CanIgnoreReturnValue
    public long accumulateAndGet(K key, long x, LongBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull(accumulatorFunction);
        return this.updateAndGet(key, oldValue -> accumulatorFunction.applyAsLong(oldValue, x));
    }

    @CanIgnoreReturnValue
    public long getAndAccumulate(K key, long x, LongBinaryOperator accumulatorFunction) {
        Preconditions.checkNotNull(accumulatorFunction);
        return this.getAndUpdate(key, oldValue -> accumulatorFunction.applyAsLong(oldValue, x));
    }

    @CanIgnoreReturnValue
    public long put(K key, long newValue) {
        return this.getAndUpdate(key, x -> newValue);
    }

    public void putAll(Map<? extends K, ? extends Long> m) {
        m.forEach(this::put);
    }

    @CanIgnoreReturnValue
    public long remove(K key) {
        Long result2 = this.map.remove(key);
        return result2 == null ? 0L : result2;
    }

    boolean remove(K key, long value2) {
        return this.map.remove(key, value2);
    }

    @CanIgnoreReturnValue
    public boolean removeIfZero(K key) {
        return this.remove(key, 0L);
    }

    public void removeAllZeros() {
        this.map.values().removeIf(x -> x == 0L);
    }

    public long sum() {
        return this.map.values().stream().mapToLong(Long::longValue).sum();
    }

    public Map<K, Long> asMap() {
        Map<K, Long> result2 = this.asMap;
        return result2 == null ? (this.asMap = this.createAsMap()) : result2;
    }

    private Map<K, Long> createAsMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    long putIfAbsent(K key, long newValue) {
        AtomicBoolean noValue = new AtomicBoolean(false);
        Long result2 = this.map.compute(key, (k, oldValue) -> {
            if (oldValue == null || oldValue == 0L) {
                noValue.set(true);
                return newValue;
            }
            return oldValue;
        });
        return noValue.get() ? 0L : Objects.requireNonNull(result2);
    }

    boolean replace(K key, long expectedOldValue, long newValue) {
        if (expectedOldValue == 0L) {
            return this.putIfAbsent(key, newValue) == 0L;
        }
        return this.map.replace(key, expectedOldValue, newValue);
    }
}

