/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.nodejs;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.OsType;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.Platform;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0000\u001a&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0000\u001a\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0000\u00a8\u0006\u0013"}, d2={"computeNodeBinDir", "Ljava/io/File;", "nodeDirProvider", "isWindows", "", "computeNpmScriptFile", "", "command", "parseOsArch", "arch", "uname", "Lorg/gradle/api/provider/Provider;", "parseOsType", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/OsType;", "type", "parsePlatform", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/Platform;", "name", "parseWindowsArch", "kotlin-gradle-plugin_common"})
public final class PlatformKt {
    @NotNull
    public static final Platform parsePlatform(@NotNull String name, @NotNull String arch, @NotNull Provider<String> uname) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Intrinsics.checkNotNullParameter(uname, (String)"uname");
        OsType osType = PlatformKt.parseOsType(name);
        if (osType == OsType.WINDOWS) {
            String string3 = arch.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            string2 = PlatformKt.parseWindowsArch(string3, uname);
        } else {
            String string4 = arch.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            string2 = PlatformKt.parseOsArch(string4, uname);
        }
        String osArch = string2;
        return new Platform(osType.getOsName(), osArch);
    }

    @NotNull
    public static final OsType parseOsType(@NotNull String type) {
        OsType osType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string2 = type.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String name = string2;
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"windows", (boolean)false, (int)2, null)) {
            osType = OsType.WINDOWS;
        } else if (StringsKt.contains$default((CharSequence)name, (CharSequence)"mac", (boolean)false, (int)2, null)) {
            osType = OsType.MAC;
        } else if (StringsKt.contains$default((CharSequence)name, (CharSequence)"linux", (boolean)false, (int)2, null)) {
            osType = OsType.LINUX;
        } else if (StringsKt.contains$default((CharSequence)name, (CharSequence)"freebsd", (boolean)false, (int)2, null)) {
            osType = OsType.FREEBSD;
        } else {
            throw new IllegalStateException(("Unsupported OS: " + name).toString());
        }
        return osType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String parseOsArch(@NotNull String arch, @NotNull Provider<String> uname) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Intrinsics.checkNotNullParameter(uname, (String)"uname");
        if (Intrinsics.areEqual((Object)arch, (Object)"arm") || StringsKt.startsWith$default((String)arch, (String)"aarch", (boolean)false, (int)2, null)) {
            void var2_2;
            String it = (String)uname.get();
            boolean bl = false;
            it = Intrinsics.areEqual((Object)it, (Object)"armv8l") || Intrinsics.areEqual((Object)it, (Object)"aarch64") ? "arm64" : it;
            boolean bl2 = false;
            Object object = Intrinsics.areEqual((Object)it, (Object)"x86_64") ? "x64" : var2_2;
            string2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uname.get()\n            \u2026  } else it\n            }");
        } else {
            string2 = Intrinsics.areEqual((Object)arch, (Object)"ppc64le") ? "ppc64le" : (Intrinsics.areEqual((Object)arch, (Object)"s390x") ? "s390x" : (StringsKt.contains$default((CharSequence)arch, (CharSequence)"64", (boolean)false, (int)2, null) ? "x64" : "x86"));
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String parseWindowsArch(@NotNull String arch, @NotNull Provider<String> uname) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter(uname, (String)"uname");
            if (!StringsKt.startsWith$default((String)arch, (String)"aarch", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)arch, (String)"arm", (boolean)false, (int)2, null)) break block13;
            String wmiArch = (String)uname.get();
            String string2 = wmiArch;
            if (string2 == null) throw new IllegalStateException(("Unexpected Win32_Processor.Architecture: " + arch).toString());
            int n = -1;
            switch (string2.hashCode()) {
                case 48: {
                    if (string2.equals("0")) {
                        n = 1;
                    }
                    break;
                }
                case 1569: {
                    if (string2.equals("12")) {
                        n = 2;
                    }
                    break;
                }
                case 57: {
                    if (string2.equals("9")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    return "arm64";
                }
                case 3: {
                    return "x64";
                }
                case 1: {
                    return "x86";
                }
                default: {
                    throw new IllegalStateException(("Unexpected Win32_Processor.Architecture: " + arch).toString());
                }
            }
        }
        if (!StringsKt.contains$default((CharSequence)arch, (CharSequence)"64", (boolean)false, (int)2, null)) return "x86";
        return "x64";
    }

    @NotNull
    public static final String computeNpmScriptFile(@NotNull File nodeDirProvider, @NotNull String command, boolean isWindows2) {
        Intrinsics.checkNotNullParameter((Object)nodeDirProvider, (String)"nodeDirProvider");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        File nodeDir = nodeDirProvider;
        boolean bl = false;
        String string2 = isWindows2 ? FilesKt.resolve((File)nodeDir, (String)("node_modules/npm/bin/" + command + "-cli.js")).getPath() : FilesKt.resolve((File)nodeDir, (String)("lib/node_modules/npm/bin/" + command + "-cli.js")).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nodeDirProvider.let { no\u2026mmand-cli.js\").path\n    }");
        return string2;
    }

    @NotNull
    public static final File computeNodeBinDir(@NotNull File nodeDirProvider, boolean isWindows2) {
        Intrinsics.checkNotNullParameter((Object)nodeDirProvider, (String)"nodeDirProvider");
        return isWindows2 ? nodeDirProvider : FilesKt.resolve((File)nodeDirProvider, (String)"bin");
    }
}

