/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes;

import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteConsumer;

public interface ByteIterator
extends PrimitiveIterator<Byte, ByteConsumer> {
    public byte nextByte();

    @Override
    @Deprecated
    default public Byte next() {
        return this.nextByte();
    }

    @Override
    default public void forEachRemaining(ByteConsumer action2) {
        Objects.requireNonNull(action2);
        while (this.hasNext()) {
            action2.accept(this.nextByte());
        }
    }

    @Override
    default public void forEachRemaining(IntConsumer action2) {
        Objects.requireNonNull(action2);
        this.forEachRemaining(action2 instanceof ByteConsumer ? (ByteConsumer)action2 : action2::accept);
    }

    @Override
    @Deprecated
    default public void forEachRemaining(Consumer<? super Byte> action2) {
        this.forEachRemaining(action2 instanceof ByteConsumer ? (ByteConsumer)action2 : action2::accept);
    }

    default public int skip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument must be nonnegative: " + n);
        }
        int i2 = n;
        while (i2-- != 0 && this.hasNext()) {
            this.nextByte();
        }
        return n - i2 - 1;
    }
}

