/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats;

import java.util.function.DoubleToIntFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Function;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.SafeMath;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.Byte2CharFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.Byte2FloatFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.Char2ByteFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.Char2CharFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.Char2DoubleFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.Char2FloatFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.Char2IntFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.Char2LongFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.Char2ObjectFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.Char2ReferenceFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.Char2ShortFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.Double2CharFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.Double2FloatFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.Float2ByteFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.Float2DoubleFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.Float2IntFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.Float2LongFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.Float2ReferenceFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.Float2ShortFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2CharFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.Int2FloatFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.Long2CharFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.Long2FloatFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2CharFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2FloatFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Reference2CharFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Reference2FloatFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.Short2CharFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.Short2FloatFunction;

@FunctionalInterface
public interface Float2CharFunction
extends Function<Float, Character>,
DoubleToIntFunction {
    @Override
    @Deprecated
    default public int applyAsInt(double operand) {
        return this.get(SafeMath.safeDoubleToFloat(operand));
    }

    @Override
    default public char put(float key, char value2) {
        throw new UnsupportedOperationException();
    }

    public char get(float var1);

    default public char getOrDefault(float key, char defaultValue) {
        char v = this.get(key);
        return v != this.defaultReturnValue() || this.containsKey(key) ? v : defaultValue;
    }

    default public char remove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public Character put(Float key, Character value2) {
        float k = key.floatValue();
        boolean containsKey = this.containsKey(k);
        char v = this.put(k, value2.charValue());
        return containsKey ? Character.valueOf(v) : null;
    }

    @Override
    @Deprecated
    default public Character get(Object key) {
        if (key == null) {
            return null;
        }
        float k = ((Float)key).floatValue();
        char v = this.get(k);
        return v != this.defaultReturnValue() || this.containsKey(k) ? Character.valueOf(v) : null;
    }

    @Override
    @Deprecated
    default public Character getOrDefault(Object key, Character defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        float k = ((Float)key).floatValue();
        char v = this.get(k);
        return v != this.defaultReturnValue() || this.containsKey(k) ? Character.valueOf(v) : defaultValue;
    }

    @Override
    @Deprecated
    default public Character remove(Object key) {
        if (key == null) {
            return null;
        }
        float k = ((Float)key).floatValue();
        return this.containsKey(k) ? Character.valueOf(this.remove(k)) : null;
    }

    default public boolean containsKey(float key) {
        return true;
    }

    @Override
    @Deprecated
    default public boolean containsKey(Object key) {
        return key == null ? false : this.containsKey(((Float)key).floatValue());
    }

    default public void defaultReturnValue(char rv) {
        throw new UnsupportedOperationException();
    }

    default public char defaultReturnValue() {
        return '\u0000';
    }

    @Override
    @Deprecated
    default public <T> java.util.function.Function<T, Character> compose(java.util.function.Function<? super T, ? extends Float> before) {
        return Function.super.compose(before);
    }

    @Override
    @Deprecated
    default public <T> java.util.function.Function<Float, T> andThen(java.util.function.Function<? super Character, ? extends T> after) {
        return Function.super.andThen(after);
    }

    default public Float2ByteFunction andThenByte(Char2ByteFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Byte2CharFunction composeByte(Byte2FloatFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Float2ShortFunction andThenShort(Char2ShortFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Short2CharFunction composeShort(Short2FloatFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Float2IntFunction andThenInt(Char2IntFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Int2CharFunction composeInt(Int2FloatFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Float2LongFunction andThenLong(Char2LongFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Long2CharFunction composeLong(Long2FloatFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Float2CharFunction andThenChar(Char2CharFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Char2CharFunction composeChar(Char2FloatFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Float2FloatFunction andThenFloat(Char2FloatFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Float2CharFunction composeFloat(Float2FloatFunction before) {
        return k -> this.get(before.get(k));
    }

    default public Float2DoubleFunction andThenDouble(Char2DoubleFunction after) {
        return k -> after.get(this.get(k));
    }

    default public Double2CharFunction composeDouble(Double2FloatFunction before) {
        return k -> this.get(before.get(k));
    }

    default public <T> Float2ObjectFunction<T> andThenObject(Char2ObjectFunction<? extends T> after) {
        return k -> after.get(this.get(k));
    }

    default public <T> Object2CharFunction<T> composeObject(Object2FloatFunction<? super T> before) {
        return k -> this.get(before.getFloat(k));
    }

    default public <T> Float2ReferenceFunction<T> andThenReference(Char2ReferenceFunction<? extends T> after) {
        return k -> after.get(this.get(k));
    }

    default public <T> Reference2CharFunction<T> composeReference(Reference2FloatFunction<? super T> before) {
        return k -> this.get(before.getFloat(k));
    }
}

