/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.reflect.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
public abstract class AbstractInvocationHandler
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];

    @Override
    @CheckForNull
    public final Object invoke(Object proxy, Method method, @CheckForNull @Nullable Object[] args2) throws Throwable {
        if (args2 == null) {
            args2 = NO_ARGS;
        }
        if (args2.length == 0 && method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (args2.length == 1 && method.getName().equals("equals") && method.getParameterTypes()[0] == Object.class) {
            Object arg2 = args2[0];
            if (arg2 == null) {
                return false;
            }
            if (proxy == arg2) {
                return true;
            }
            return AbstractInvocationHandler.isProxyOfSameInterfaces(arg2, proxy.getClass()) && this.equals(Proxy.getInvocationHandler(arg2));
        }
        if (args2.length == 0 && method.getName().equals("toString")) {
            return this.toString();
        }
        return this.handleInvocation(proxy, method, args2);
    }

    @CheckForNull
    protected abstract Object handleInvocation(Object var1, Method var2, @Nullable Object[] var3) throws Throwable;

    public boolean equals(@CheckForNull Object obj2) {
        return super.equals(obj2);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    private static boolean isProxyOfSameInterfaces(Object arg2, Class<?> proxyClass) {
        return proxyClass.isInstance(arg2) || Proxy.isProxyClass(arg2.getClass()) && Arrays.equals(arg2.getClass().getInterfaces(), proxyClass.getInterfaces());
    }
}

