/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.execution.rmi;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.execution.rmi.IdeaWatchdog;

final class IdeaWatchdogImpl
implements IdeaWatchdog {
    private static final long DEFAULT_WAIT_TIMEOUT_MILLIS = 20000L;
    private static final long DEFAULT_PULSE_TIMEOUT_MILLIS = 9000L;
    private final long myWaitTimeoutMillis;
    private final long myPulseTimeoutMillis;
    private final AtomicBoolean isAlive = new AtomicBoolean(true);
    private volatile long lastTimePinged = System.currentTimeMillis();

    IdeaWatchdogImpl() {
        this(20000L, 9000L);
    }

    IdeaWatchdogImpl(long waitTimeoutMillis, long pulseTimeoutMillis) {
        this.myWaitTimeoutMillis = waitTimeoutMillis;
        this.myPulseTimeoutMillis = pulseTimeoutMillis;
    }

    @Override
    public boolean ping() {
        this.lastTimePinged = System.currentTimeMillis();
        return this.isAlive();
    }

    @Override
    @TestOnly
    public void dieNowTestOnly(int exitCode) {
        System.exit(exitCode);
    }

    @Override
    public boolean die() {
        return this.isAlive.compareAndSet(true, false);
    }

    @Override
    public boolean isAlive() {
        boolean pingedRecently;
        boolean bl = pingedRecently = System.currentTimeMillis() - this.lastTimePinged < this.myWaitTimeoutMillis;
        if (!this.isAlive.compareAndSet(true, pingedRecently)) {
            return false;
        }
        return pingedRecently;
    }

    @Override
    public long getWaitTimeoutMillis() {
        return this.myWaitTimeoutMillis;
    }

    @Override
    public long getPulseTimeoutMillis() {
        return this.myPulseTimeoutMillis;
    }
}

