/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Arrays;
import java.util.EmptyStackException;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

@Deprecated
public class IntStack
implements Cloneable {
    private int[] data;
    private int size;

    public IntStack(int initialCapacity) {
        this.data = new int[initialCapacity];
        this.size = 0;
    }

    public IntStack() {
        this(5);
    }

    public void push(int t) {
        if (this.size >= this.data.length) {
            this.data = ArrayUtil.realloc(this.data, this.data.length * 3 / 2);
        }
        this.data[this.size++] = t;
    }

    public int peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.data[this.size - 1];
    }

    public int pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.data[--this.size];
    }

    public int get(int i2) {
        if (i2 < 0 || i2 >= this.size) {
            throw new IndexOutOfBoundsException("Invalid stack index " + i2 + " for stack of size " + this.size);
        }
        return this.data[i2];
    }

    public int size() {
        return this.size;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof IntStack) {
            IntStack otherStack = (IntStack)o;
            if (this.size != otherStack.size) {
                return false;
            }
            for (int i2 = 0; i2 < otherStack.size; ++i2) {
                if (this.data[i2] == otherStack.data[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.size = 0;
    }

    public String toString() {
        return Arrays.toString(Arrays.copyOf(this.data, this.size));
    }

    public IntStack clone() {
        try {
            IntStack v = (IntStack)super.clone();
            v.data = (int[])this.data.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

