/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.YieldKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.io.ProcessKt;
import org.jetbrains.kotlin.com.intellij.util.text.CharSequenceBackedByChars;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a1\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u001a\r\u0010\n\u001a\u00020\u000b*\u00020\fH\u0087\b\u001a\r\u0010\r\u001a\u00020\f*\u00020\fH\u0087\b\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006\u001a\u0014\u0010\u0012\u001a\u00020\u000b*\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"copyToAsync", "", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "bufferSize", "", "limit", "", "(Ljava/io/InputStream;Ljava/io/OutputStream;IJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "decodeBase64", "", "", "encodeUrlQueryParameter", "readCharSequence", "", "Ljava/io/Reader;", "length", "toByteArray", "Ljava/nio/ByteBuffer;", "isClear", "", "intellij.platform.util"})
public final class IoKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CharSequence readCharSequence(@NotNull Reader $this$readCharSequence, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$readCharSequence, (String)"<this>");
        Closeable closeable = $this$readCharSequence;
        Throwable throwable = null;
        try {
            int count;
            int n;
            Reader it = (Reader)closeable;
            boolean bl = false;
            char[] chars = new char[length];
            for (count = 0; count < chars.length && (n = $this$readCharSequence.read(chars, count, chars.length - count)) > 0; count += n) {
            }
            CharSequence charSequence = new CharSequenceBackedByChars(chars, 0, count);
            return charSequence;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final CharSequence readCharSequence(@NotNull Reader $this$readCharSequence) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$readCharSequence, (String)"<this>");
        char[] chars = new char[8192];
        List buffers = null;
        int count = 0;
        int total = 0;
        while ((n = $this$readCharSequence.read(chars, count, chars.length - count)) > 0) {
            total += n;
            if ((count += n) != chars.length) continue;
            if (buffers == null) {
                buffers = new SmartList();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count = 0;
        }
        if (buffers == null) {
            return new CharSequenceBackedByChars(chars, 0, total);
        }
        char[] result2 = new char[total];
        for (char[] buffer : buffers) {
            System.arraycopy(buffer, 0, result2, result2.length - total, buffer.length);
            total -= buffer.length;
        }
        System.arraycopy(chars, 0, result2, result2.length - total, total);
        return new CharSequenceBackedByChars(result2);
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull ByteBuffer $this$toByteArray, boolean isClear) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        if ($this$toByteArray.hasArray()) {
            int offset = $this$toByteArray.arrayOffset();
            byte[] array2 = $this$toByteArray.array();
            if (offset == 0 && array2.length == $this$toByteArray.limit()) {
                Intrinsics.checkNotNull((Object)array2);
                return array2;
            }
            Intrinsics.checkNotNull((Object)array2);
            byte[] byArray = array2;
            int n = offset + $this$toByteArray.limit();
            byte[] result2 = ArraysKt.copyOfRange((byte[])byArray, (int)offset, (int)n);
            if (isClear) {
                ArraysKt.fill$default((byte[])array2, (byte)0, (int)0, (int)0, (int)6, null);
            }
            return result2;
        }
        byte[] bytes = new byte[$this$toByteArray.limit() - $this$toByteArray.position()];
        $this$toByteArray.get(bytes);
        return bytes;
    }

    public static /* synthetic */ byte[] toByteArray$default(ByteBuffer byteBuffer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return IoKt.toByteArray(byteBuffer, bl);
    }

    @Deprecated(message="Use URLEncoder.encode()")
    @NotNull
    public static final String encodeUrlQueryParameter(@NotNull String $this$encodeUrlQueryParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeUrlQueryParameter, (String)"<this>");
        boolean $i$f$encodeUrlQueryParameter = false;
        String string2 = URLEncoder.encode($this$encodeUrlQueryParameter, Charsets.UTF_8.name());
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    @Deprecated(message="Use java.util.Base64.getDecoder().decode()")
    @NotNull
    public static final byte[] decodeBase64(@NotNull String $this$decodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64, (String)"<this>");
        boolean $i$f$decodeBase64 = false;
        byte[] byArray = Base64.getDecoder().decode($this$decodeBase64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }

    @ApiStatus.Experimental
    @Nullable
    public static final Object copyToAsync(@NotNull InputStream $this$copyToAsync, @NotNull OutputStream outputStream, int bufferSize, long limit, @NotNull Continuation<? super Unit> $completion) {
        Object object = ProcessKt.computeDetached((CoroutineContext)new CoroutineName("copyToAsync: " + $this$copyToAsync + " => " + outputStream), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(bufferSize, limit, $this$copyToAsync, outputStream, null){
            Object L$0;
            long J$0;
            int I$0;
            int label;
            final /* synthetic */ int $bufferSize;
            final /* synthetic */ long $limit;
            final /* synthetic */ InputStream $this_copyToAsync;
            final /* synthetic */ OutputStream $outputStream;
            {
                this.$bufferSize = $bufferSize;
                this.$limit = $limit;
                this.$this_copyToAsync = $receiver;
                this.$outputStream = $outputStream;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        buffer = new byte[this.$bufferSize];
                        totalRead = 0L;
lbl7:
                        // 4 sources

                        while (totalRead < this.$limit) {
                            this.L$0 = buffer;
                            this.J$0 = totalRead;
                            this.label = 1;
                            v0 = YieldKt.yield((Continuation)((Continuation)this));
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl21
                        }
                        break;
                    }
                    case 1: {
                        totalRead = this.J$0;
                        buffer = (byte[])this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl21:
                        // 2 sources

                        try {
                            var6_6 = this.$this_copyToAsync.read(buffer, 0, (int)Math.min(this.$limit - totalRead, (long)buffer.length));
                        }
                        catch (SocketTimeoutException var7_7) {
                            ** GOTO lbl7
                        }
                        read = var6_6;
                        if (read < 0) break;
                        if (read <= 0) ** GOTO lbl7
                        this.L$0 = buffer;
                        this.J$0 = totalRead += (long)read;
                        this.I$0 = read;
                        this.label = 2;
                        v1 = YieldKt.yield((Continuation)((Continuation)this));
                        if (v1 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl45
                    }
                    case 2: {
                        read = this.I$0;
                        totalRead = this.J$0;
                        buffer = (byte[])this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl45:
                        // 2 sources

                        this.$outputStream.write(buffer, 0, read);
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object copyToAsync$default(InputStream inputStream, OutputStream outputStream, int n, long l, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        if ((n2 & 4) != 0) {
            l = Long.MAX_VALUE;
        }
        return IoKt.copyToAsync(inputStream, outputStream, n, l, (Continuation<? super Unit>)continuation);
    }
}

