/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils.processes;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.utils.processes.ExecAsyncHandle;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B@\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0001H\u0016J\b\u0010 \u001a\u00020\u000eH\u0002J\f\u0010!\u001a\u00060\u0014j\u0002`\u0015H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/processes/ExecAsyncHandleImpl;", "Lorg/jetbrains/kotlin/gradle/utils/processes/ExecAsyncHandle;", "displayName", "", "abortTimeout", "Ljava/time/Duration;", "execOperations", "Lorg/gradle/process/ExecOperations;", "configure", "Lkotlin/Function1;", "Lorg/gradle/process/ExecSpec;", "Lkotlin/ParameterName;", "name", "execSpec", "", "(Ljava/lang/String;Ljava/time/Duration;Lorg/gradle/process/ExecOperations;Lkotlin/jvm/functions/Function1;)V", "getDisplayName", "()Ljava/lang/String;", "failure", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logTag", "result", "Lorg/gradle/process/ExecResult;", "thread", "Ljava/lang/Thread;", "abort", "exec", "isAlive", "", "start", "waitForCompletion", "waitForFailure", "waitForResult", "Companion", "kotlin-gradle-plugin_common"})
final class ExecAsyncHandleImpl
implements ExecAsyncHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String displayName;
    @NotNull
    private final Duration abortTimeout;
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final Function1<ExecSpec, Unit> configure;
    @NotNull
    private final String logTag;
    @NotNull
    private final AtomicReference<ExecResult> result;
    @NotNull
    private final AtomicReference<Exception> failure;
    @NotNull
    private final Thread thread;
    @NotNull
    private static final Logger logger;

    public ExecAsyncHandleImpl(@NotNull String displayName, @NotNull Duration abortTimeout, @NotNull ExecOperations execOperations, @NotNull Function1<? super ExecSpec, Unit> configure2) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)abortTimeout, (String)"abortTimeout");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        Intrinsics.checkNotNullParameter(configure2, (String)"configure");
        this.displayName = displayName;
        this.abortTimeout = abortTimeout;
        this.execOperations = execOperations;
        this.configure = configure2;
        this.logTag = "[ExecAsyncHandle " + this.getDisplayName() + ']';
        this.result = new AtomicReference<Object>(null);
        this.failure = new AtomicReference<Object>(null);
        String string = this.getDisplayName();
        this.thread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)string, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ExecAsyncHandleImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ExecAsyncHandleImpl.access$getLogger$cp().info(ExecAsyncHandleImpl.access$getLogTag$p(this.this$0) + " started");
                try {
                    ExecAsyncHandleImpl.access$getResult$p(this.this$0).set(ExecAsyncHandleImpl.access$exec(this.this$0));
                    ExecAsyncHandleImpl.access$getLogger$cp().info(ExecAsyncHandleImpl.access$getLogTag$p(this.this$0) + " finished " + ExecAsyncHandleImpl.access$getResult$p(this.this$0).get());
                }
                catch (Exception e) {
                    ExecAsyncHandleImpl.access$getFailure$p(this.this$0).set(e);
                    ExecAsyncHandleImpl.access$getLogger$cp().info(ExecAsyncHandleImpl.access$getLogTag$p(this.this$0) + " failed " + e);
                }
            }
        }), (int)20, null);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    private final ExecResult exec() {
        ExecResult execResult = this.execOperations.exec(new Action(this){
            final /* synthetic */ ExecAsyncHandleImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ExecSpec exec2) {
                exec2.setIgnoreExitValue(true);
                Function1 function1 = ExecAsyncHandleImpl.access$getConfigure$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)exec2, (String)"exec");
                function1.invoke((Object)exec2);
                Logger logger2 = ExecAsyncHandleImpl.access$getLogger$cp();
                StringBuilder stringBuilder = new StringBuilder().append(ExecAsyncHandleImpl.access$getLogTag$p(this.this$0)).append(" created ExecSpec. Command: ");
                List list = exec2.getCommandLine();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"exec.commandLine");
                logger2.debug(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)).append(", Environment: ").append(exec2.getEnvironment()).append(", WorkingDir: ").append(exec2.getWorkingDir()).toString());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)execResult, (String)"private fun exec(): Exec\u2026ingDir}\")\n        }\n    }");
        return execResult;
    }

    @Override
    @NotNull
    public ExecAsyncHandle start() {
        this.thread.start();
        return this;
    }

    @Override
    @Nullable
    public ExecResult waitForResult() {
        this.waitForCompletion();
        if (this.failure.get() != null) {
            return null;
        }
        ExecResult execResult = this.result.get();
        if (execResult == null) {
            boolean bl = false;
            String string = this.logTag + " result is null";
            throw new IllegalArgumentException(string.toString());
        }
        return execResult;
    }

    @Override
    @NotNull
    public Exception waitForFailure() {
        this.waitForCompletion();
        Exception exception = this.failure.get();
        if (exception == null) {
            boolean bl = false;
            String string = this.logTag + " failure is null";
            throw new IllegalArgumentException(string.toString());
        }
        return exception;
    }

    @Override
    public void abort() {
        this.thread.interrupt();
        logger.info(this.logTag + " aborted");
    }

    private final void waitForCompletion() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            logger.info(this.logTag + " interrupted " + ex);
            this.thread.interrupt();
            this.thread.join(this.abortTimeout.toMillis());
        }
    }

    @Override
    public boolean isAlive() {
        return !this.thread.isAlive();
    }

    public static final /* synthetic */ Function1 access$getConfigure$p(ExecAsyncHandleImpl $this) {
        return $this.configure;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ String access$getLogTag$p(ExecAsyncHandleImpl $this) {
        return $this.logTag;
    }

    public static final /* synthetic */ AtomicReference access$getResult$p(ExecAsyncHandleImpl $this) {
        return $this.result;
    }

    public static final /* synthetic */ ExecResult access$exec(ExecAsyncHandleImpl $this) {
        return $this.exec();
    }

    public static final /* synthetic */ AtomicReference access$getFailure$p(ExecAsyncHandleImpl $this) {
        return $this.failure;
    }

    static {
        Logger logger2 = Logging.getLogger(ExecAsyncHandle.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(ExecAsyncHandle::class.java)");
        logger = logger2;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/processes/ExecAsyncHandleImpl$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

