/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.statistics;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.statistics.DaemonReuseCounter;
import org.jetbrains.kotlin.gradle.plugin.statistics.FusMetrics;
import org.jetbrains.kotlin.gradle.utils.ReportUtilsKt;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ9\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/statistics/BuildFinishMetrics;", "Lorg/jetbrains/kotlin/gradle/plugin/statistics/FusMetrics;", "()V", "collectMetrics", "", "logger", "Lorg/gradle/api/logging/Logger;", "buildFailed", "", "buildStartTime", "", "projectEvaluatedTime", "metricsConsumer", "Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;", "(Lorg/gradle/api/logging/Logger;ZLjava/lang/Long;Ljava/lang/Long;Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;)V", "reportBuildFinished", "buildStartedTime", "metricsContainer", "reportGlobalMetrics", "metricConsumer", "kotlin-gradle-plugin_common"})
public final class BuildFinishMetrics
implements FusMetrics {
    @NotNull
    public static final BuildFinishMetrics INSTANCE = new BuildFinishMetrics();

    private BuildFinishMetrics() {
    }

    public final void collectMetrics(@NotNull Logger logger2, boolean buildFailed, @Nullable Long buildStartTime, @Nullable Long projectEvaluatedTime, @NotNull StatisticsValuesConsumer metricsConsumer) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)metricsConsumer, (String)"metricsConsumer");
        this.reportGlobalMetrics(logger2, metricsConsumer);
        this.reportBuildFinished(logger2, buildFailed, buildStartTime, projectEvaluatedTime, metricsConsumer);
    }

    private final void reportGlobalMetrics(Logger logger2, StatisticsValuesConsumer metricConsumer) {
        ReportUtilsKt.runMetricMethodSafely(logger2, "reportGlobalMetrics", (Function0)new Function0<Boolean>(metricConsumer){
            final /* synthetic */ StatisticsValuesConsumer $metricConsumer;
            {
                this.$metricConsumer = $metricConsumer;
                super(0);
            }

            public final Boolean invoke() {
                String string = System.getProperty("os.name");
                if (string != null) {
                    String string2 = string;
                    StatisticsValuesConsumer statisticsValuesConsumer = this.$metricConsumer;
                    String it = string2;
                    boolean bl = false;
                    String string3 = System.getProperty("os.name");
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(\"os.name\")");
                    StatisticsValuesConsumer.DefaultImpls.report$default(statisticsValuesConsumer, StringMetrics.OS_TYPE, string3, null, null, 12, null);
                }
                StatisticsValuesConsumer.DefaultImpls.report$default(this.$metricConsumer, NumericalMetrics.CPU_NUMBER_OF_CORES, Runtime.getRuntime().availableProcessors(), null, null, 12, null);
                StatisticsValuesConsumer.DefaultImpls.report$default(this.$metricConsumer, BooleanMetrics.EXECUTED_FROM_IDEA, System.getProperty("idea.active") != null, null, null, 12, null);
                StatisticsValuesConsumer.DefaultImpls.report$default(this.$metricConsumer, NumericalMetrics.GRADLE_DAEMON_HEAP_SIZE, Runtime.getRuntime().maxMemory(), null, null, 12, null);
                return StatisticsValuesConsumer.DefaultImpls.report$default(this.$metricConsumer, NumericalMetrics.GRADLE_BUILD_NUMBER_IN_CURRENT_DAEMON, DaemonReuseCounter.Companion.incrementAndGetOrdinal(), null, null, 12, null);
            }
        });
    }

    private final void reportBuildFinished(Logger logger2, boolean buildFailed, Long buildStartedTime, Long projectEvaluatedTime, StatisticsValuesConsumer metricsContainer) {
        ReportUtilsKt.runMetricMethodSafely(logger2, "reportBuildFinish", (Function0)new Function0<Boolean>(buildStartedTime, metricsContainer, projectEvaluatedTime, buildFailed){
            final /* synthetic */ Long $buildStartedTime;
            final /* synthetic */ StatisticsValuesConsumer $metricsContainer;
            final /* synthetic */ Long $projectEvaluatedTime;
            final /* synthetic */ boolean $buildFailed;
            {
                this.$buildStartedTime = $buildStartedTime;
                this.$metricsContainer = $metricsContainer;
                this.$projectEvaluatedTime = $projectEvaluatedTime;
                this.$buildFailed = $buildFailed;
                super(0);
            }

            public final Boolean invoke() {
                long finishTime = System.currentTimeMillis();
                if (this.$buildStartedTime != null) {
                    StatisticsValuesConsumer.DefaultImpls.report$default(this.$metricsContainer, NumericalMetrics.GRADLE_BUILD_DURATION, finishTime - this.$buildStartedTime, null, null, 12, null);
                }
                if (this.$projectEvaluatedTime != null) {
                    StatisticsValuesConsumer.DefaultImpls.report$default(this.$metricsContainer, NumericalMetrics.GRADLE_EXECUTION_DURATION, finishTime - this.$projectEvaluatedTime, null, null, 12, null);
                }
                StatisticsValuesConsumer.DefaultImpls.report$default(this.$metricsContainer, NumericalMetrics.BUILD_FINISH_TIME, finishTime, null, null, 12, null);
                return StatisticsValuesConsumer.DefaultImpls.report$default(this.$metricsContainer, BooleanMetrics.BUILD_FAILED, this.$buildFailed, null, null, 12, null);
            }
        });
    }
}

