/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.incremental.BaseCompilationTransaction;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.RecoverableCompilationTransaction;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u000f\u0010\u0011\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0017R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001aR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001bR4\u0010\u001e\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001cj\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/incremental/RecoverableCompilationTransaction;", "Lorg/jetbrains/kotlin/incremental/CompilationTransaction;", "Lorg/jetbrains/kotlin/incremental/BaseCompilationTransaction;", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "reporter", "Ljava/nio/file/Path;", "stashDir", "<init>", "(Lorg/jetbrains/kotlin/build/report/BuildReporter;Ljava/nio/file/Path;)V", "outputFile", "", "registerAddedOrChangedFile", "(Ljava/nio/file/Path;)V", "deleteFile", "stashFile", "getNextRelocatedFilePath", "()Ljava/nio/file/Path;", "", "isFileRelocationIsAlreadyRegisteredFor", "(Ljava/nio/file/Path;)Z", "revertChanges", "()V", "cleanupStash", "close", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Ljava/nio/file/Path;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "fileRelocationRegistry", "Ljava/util/HashMap;", "", "filesCounter", "I", "kotlin-build-common"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\nCompilationTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationTransaction.kt\norg/jetbrains/kotlin/incremental/RecoverableCompilationTransaction\n+ 2 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 File.kt\norg/jetbrains/kotlin/konan/file/FileKt\n*L\n1#1,282:1\n31#2,5:283\n31#2,5:288\n31#2,5:294\n31#2,3:299\n35#2:315\n1#3:293\n214#4,13:302\n*S KotlinDebug\n*F\n+ 1 CompilationTransaction.kt\norg/jetbrains/kotlin/incremental/RecoverableCompilationTransaction\n*L\n179#1:283,5\n201#1:288,5\n223#1:294,5\n241#1:299,3\n241#1:315\n242#1:302,13\n*E\n"})
public final class RecoverableCompilationTransaction
extends BaseCompilationTransaction
implements CompilationTransaction {
    @NotNull
    private final BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter;
    @NotNull
    private final Path stashDir;
    @NotNull
    private final HashMap<Path, Path> fileRelocationRegistry;
    private int filesCounter;

    public RecoverableCompilationTransaction(@NotNull BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> reporter, @NotNull Path stashDir) {
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)stashDir, (String)"stashDir");
        this.reporter = reporter;
        this.stashDir = stashDir;
        this.fileRelocationRegistry = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void registerAddedOrChangedFile(@NotNull Path outputFile2) {
        void $this$measure$iv;
        Intrinsics.checkNotNullParameter((Object)outputFile2, (String)"outputFile");
        if (this.isFileRelocationIsAlreadyRegisteredFor(outputFile2)) {
            return;
        }
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = (BuildTime)GradleBuildTime.PRECISE_BACKUP_OUTPUT;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            if (Files.exists(outputFile2, new LinkOption[0])) {
                this.stashFile(outputFile2);
            } else {
                ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)() -> RecoverableCompilationTransaction.registerAddedOrChangedFile$lambda$1$lambda$0(outputFile2)));
                ((Map)this.fileRelocationRegistry).put(outputFile2, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void deleteFile(@NotNull Path outputFile2) {
        void $this$measure$iv;
        Intrinsics.checkNotNullParameter((Object)outputFile2, (String)"outputFile");
        if (!Files.exists(outputFile2, new LinkOption[0])) {
            return;
        }
        if (this.isFileRelocationIsAlreadyRegisteredFor(outputFile2)) {
            ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)() -> RecoverableCompilationTransaction.deleteFile$lambda$2(outputFile2)));
            Files.delete(outputFile2);
            return;
        }
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = (BuildTime)GradleBuildTime.PRECISE_BACKUP_OUTPUT;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            this.stashFile(outputFile2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    private final void stashFile(Path outputFile2) {
        Path relocatedFilePath = this.getNextRelocatedFilePath();
        ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)() -> RecoverableCompilationTransaction.stashFile$lambda$4(outputFile2, relocatedFilePath)));
        ((Map)this.fileRelocationRegistry).put(outputFile2, relocatedFilePath);
        Files.move(outputFile2, relocatedFilePath, new CopyOption[0]);
    }

    private final Path getNextRelocatedFilePath() {
        Path path;
        Path it = path = this.stashDir.resolve(this.filesCounter + ".backup");
        boolean bl = false;
        int n = this.filesCounter;
        this.filesCounter = n + 1;
        Path path2 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"also(...)");
        return path2;
    }

    private final boolean isFileRelocationIsAlreadyRegisteredFor(Path outputFile2) {
        return ((Map)this.fileRelocationRegistry).containsKey(outputFile2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void revertChanges() {
        void $this$measure$iv;
        ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)RecoverableCompilationTransaction::revertChanges$lambda$6));
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = (BuildTime)GradleBuildTime.RESTORE_OUTPUT_FROM_BACKUP;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            for (Map.Entry entry2 : ((Map)this.fileRelocationRegistry).entrySet()) {
                Path originPath = (Path)entry2.getKey();
                Path relocatedPath = (Path)entry2.getValue();
                if (relocatedPath == null) {
                    if (!Files.exists(originPath, new LinkOption[0])) continue;
                    Files.delete(originPath);
                    continue;
                }
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.move(relocatedPath, originPath, copyOptionArray);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void cleanupStash() {
        void $this$measure$iv;
        ICReporterKt.debug(this.reporter, (Function0<String>)((Function0)RecoverableCompilationTransaction::cleanupStash$lambda$8));
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = (BuildTime)GradleBuildTime.CLEAN_BACKUP_STASH;
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            AutoCloseable $this$use$iv = Files.walk(this.stashDir, new FileVisitOption[0]);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                Stream it = (Stream)$this$use$iv;
                boolean bl2 = false;
                it.sorted(Comparator.reverseOrder()).forEach(arg_0 -> RecoverableCompilationTransaction.cleanupStash$lambda$11$lambda$10$lambda$9(cleanupStash.2.1.1.INSTANCE, arg_0));
                it = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        AutoCloseable autoCloseable = $this$use$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    throw throwable;
                }
            }
            AutoCloseable autoCloseable = $this$use$iv;
            if (autoCloseable != null) {
                autoCloseable.close();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
    }

    @Override
    public void close() {
        Throwable exceptionToThrow;
        Throwable throwable;
        Object $this$close_u24lambda_u2412;
        this.checkForExecutionException();
        Throwable mainException = this.closeCachesManager();
        RecoverableCompilationTransaction recoverableCompilationTransaction = this;
        try {
            $this$close_u24lambda_u2412 = recoverableCompilationTransaction;
            boolean bl = false;
            if (((BaseCompilationTransaction)$this$close_u24lambda_u2412).isSuccessful()) {
                super.cleanupStash();
            } else {
                super.revertChanges();
                super.cleanupStash();
            }
            $this$close_u24lambda_u2412 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$close_u24lambda_u2412 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        Throwable $this$close_u24lambda_u2413 = Result.exceptionOrNull-impl((Object)$this$close_u24lambda_u2412);
        boolean bl = false;
        if ($this$close_u24lambda_u2413 != null) {
            Throwable throwable2 = mainException;
            if (throwable2 != null) {
                ExceptionsKt.addSuppressed((Throwable)throwable2, (Throwable)$this$close_u24lambda_u2413);
            }
        }
        if ((throwable = mainException) == null) {
            throwable = $this$close_u24lambda_u2413;
        }
        if ((exceptionToThrow = throwable) != null) {
            throw exceptionToThrow;
        }
    }

    private static final String registerAddedOrChangedFile$lambda$1$lambda$0(Path $outputFile) {
        return "Marking the " + $outputFile + " file as newly added";
    }

    private static final String deleteFile$lambda$2(Path $outputFile) {
        return "Deleting " + $outputFile;
    }

    private static final String stashFile$lambda$4(Path $outputFile, Path $relocatedFilePath) {
        return "Moving " + $outputFile + " to the stash as " + $relocatedFilePath;
    }

    private static final String revertChanges$lambda$6() {
        return "Reverting changes";
    }

    private static final String cleanupStash$lambda$8() {
        return "Cleaning up stash";
    }

    private static final void cleanupStash$lambda$11$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

