/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.nodejs;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.InternalKotlinGradlePluginApi;
import org.jetbrains.kotlin.gradle.targets.js.AbstractSetupTask;
import org.jetbrains.kotlin.gradle.targets.js.EnvSpec;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsEnv;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsSetupTask;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.PlatformKt;
import org.jetbrains.kotlin.gradle.targets.web.nodejs.BaseNodeJsEnvSpec;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@DisableCachingByDefault
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000 \u001f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001fB\u000f\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR2\u0010\u000e\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00070\u0007 \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00120\u0012 \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsSetupTask;", "Lorg/jetbrains/kotlin/gradle/targets/js/AbstractSetupTask;", "Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsEnv;", "Lorg/jetbrains/kotlin/gradle/targets/web/nodejs/BaseNodeJsEnvSpec;", "settings", "(Lorg/jetbrains/kotlin/gradle/targets/web/nodejs/BaseNodeJsEnvSpec;)V", "artifactModule", "", "getArtifactModule", "()Ljava/lang/String;", "artifactName", "getArtifactName", "artifactPattern", "getArtifactPattern", "executable", "Lorg/gradle/api/provider/Provider;", "kotlin.jvm.PlatformType", "isWindows", "", "extract", "", "archive", "Ljava/io/File;", "fixBrokenSymlink", "name", "nodeBinDirPath", "Ljava/nio/file/Path;", "nodeDirProvider", "fixBrokenSymlinks", "destinationDir", "necessaryToFix", "Companion", "kotlin-gradle-plugin_common"})
public abstract class NodeJsSetupTask
extends AbstractSetupTask<NodeJsEnv, BaseNodeJsEnvSpec> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Provider<Boolean> isWindows;
    private final Provider<String> executable;
    @NotNull
    public static final String NAME = "kotlinNodeJsSetup";
    @NotNull
    public static final String BASE_NAME = "nodeJsSetup";

    @Inject
    public NodeJsSetupTask(@NotNull BaseNodeJsEnvSpec settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super((EnvSpec)settings);
        this.isWindows = this.getEnv().map((Transformer)isWindows.1.INSTANCE);
        this.executable = this.getEnv().map((Transformer)executable.1.INSTANCE);
    }

    @Override
    @Internal
    @NotNull
    protected String getArtifactPattern() {
        return "v[revision]/[artifact](-v[revision]-[classifier]).[ext]";
    }

    @Override
    @Internal
    @NotNull
    protected String getArtifactModule() {
        return "org.nodejs";
    }

    @Override
    @Internal
    @NotNull
    protected String getArtifactName() {
        return "node";
    }

    @Override
    public void extract(@NotNull File archive) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Ref.BooleanRef fixBrokenSymLinks = new Ref.BooleanRef();
        File destination = FileUtilsKt.getFile((Provider<RegularFile>)((Provider)this.getDestinationProvider()));
        this.getFs$kotlin_gradle_plugin_common().copy(new Action(archive, this, fixBrokenSymLinks, destination){
            final /* synthetic */ File $archive;
            final /* synthetic */ NodeJsSetupTask this$0;
            final /* synthetic */ Ref.BooleanRef $fixBrokenSymLinks;
            final /* synthetic */ File $destination;
            {
                this.$archive = $archive;
                this.this$0 = $receiver;
                this.$fixBrokenSymLinks = $fixBrokenSymLinks;
                this.$destination = $destination;
            }

            public final void execute(CopySpec it) {
                FileTree fileTree;
                Object[] objectArray = new Object[1];
                String string = this.$archive.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"archive.name");
                if (StringsKt.endsWith$default((String)string, (String)"zip", (boolean)false, (int)2, null)) {
                    fileTree = this.this$0.getArchiveOperations$kotlin_gradle_plugin_common().zipTree((Object)this.$archive);
                } else {
                    this.$fixBrokenSymLinks.element = true;
                    fileTree = this.this$0.getArchiveOperations$kotlin_gradle_plugin_common().tarTree((Object)this.$archive);
                }
                objectArray[0] = fileTree;
                it.from(objectArray);
                it.into((Object)this.$destination.getParentFile());
            }
        });
        Object object = this.isWindows.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"isWindows.get()");
        this.fixBrokenSymlinks(destination, (Boolean)object, fixBrokenSymLinks.element);
        if (!((Boolean)this.isWindows.get()).booleanValue()) {
            new File((String)this.executable.get()).setExecutable(true);
        }
    }

    private final void fixBrokenSymlinks(File destinationDir2, boolean isWindows2, boolean necessaryToFix) {
        if (necessaryToFix) {
            Path nodeBinDir = PlatformKt.computeNodeBinDir(destinationDir2, isWindows2).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)nodeBinDir, (String)"nodeBinDir");
            this.fixBrokenSymlink("npm", nodeBinDir, destinationDir2, isWindows2);
            this.fixBrokenSymlink("npx", nodeBinDir, destinationDir2, isWindows2);
        }
    }

    private final void fixBrokenSymlink(String name2, Path nodeBinDirPath, File nodeDirProvider, boolean isWindows2) {
        Path script = nodeBinDirPath.resolve(name2);
        String scriptFile = PlatformKt.computeNpmScriptFile(nodeDirProvider, name2, isWindows2);
        if (Files.deleteIfExists(script)) {
            Files.createSymbolicLink(script, nodeBinDirPath.relativize(Paths.get(scriptFile, new String[0])), new FileAttribute[0]);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/nodejs/NodeJsSetupTask$Companion;", "", "()V", "BASE_NAME", "", "getBASE_NAME$annotations", "NAME", "getNAME$annotations", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use nodeJsSetupTaskProvider from corresponding NodeJsEnvSpec or WasmNodeJsEnvSpec instead. Scheduled for removal in Kotlin 2.4.")
        public static /* synthetic */ void getNAME$annotations() {
        }

        @InternalKotlinGradlePluginApi
        public static /* synthetic */ void getBASE_NAME$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

