/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.output;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.output.NoPermissionException;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.gradle.internal.backend.common.output.OutputFile;
import org.jetbrains.kotlin.gradle.internal.backend.common.output.OutputFileCollection;

@Metadata(k=2, mv={2, 0, 0}, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001aY\u0010\u000b\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012>\u0010\n\u001a:\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\r\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\r\u0010\u000e\u001a)\u0010\u000b\u001a\u00020\t*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000b\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/backend/common/output/OutputFileCollection;", "Ljava/io/File;", "outputDir", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "sources", "output", "", "report", "writeAll", "(Lorg/jetbrains/kotlin/gradle/internal/backend/common/output/OutputFileCollection;Ljava/io/File;Lkotlin/jvm/functions/Function2;)V", "writeAllTo", "(Lorg/jetbrains/kotlin/gradle/internal/backend/common/output/OutputFileCollection;Ljava/io/File;)V", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "messageCollector", "", "reportOutputFiles", "(Lorg/jetbrains/kotlin/gradle/internal/backend/common/output/OutputFileCollection;Ljava/io/File;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Z)V", "cli"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
public final class OutputUtilsKt {
    public static final void writeAll(@NotNull OutputFileCollection $this$writeAll, @NotNull File outputDir, @Nullable Function2<? super List<? extends File>, ? super File, Unit> report2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        for (OutputFile file2 : $this$writeAll.asList()) {
            List sources2 = file2.getSourceFiles();
            File output2 = new File(outputDir, file2.getRelativePath());
            Function2<? super List<? extends File>, ? super File, Unit> function2 = report2;
            if (function2 != null) {
                function2.invoke((Object)sources2, (Object)output2);
            }
            try {
                FileUtil.writeToFile((File)output2, (byte[])file2.asByteArray());
            }
            catch (FileNotFoundException e) {
                if (outputDir.isDirectory()) {
                    throw new NoPermissionException("error while writing " + output2 + " (Permission denied)", e);
                }
                throw e;
            }
        }
    }

    public static final void writeAllTo(@NotNull OutputFileCollection $this$writeAllTo, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAllTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        OutputUtilsKt.writeAll($this$writeAllTo, outputDir, null);
    }

    public static final void writeAll(@NotNull OutputFileCollection $this$writeAll, @NotNull File outputDir, @NotNull MessageCollector messageCollector, boolean reportOutputFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        try {
            if (!reportOutputFiles) {
                OutputUtilsKt.writeAllTo($this$writeAll, outputDir);
            } else {
                OutputUtilsKt.writeAll($this$writeAll, outputDir, (Function2<? super List<? extends File>, ? super File, Unit>)((Function2)(arg_0, arg_1) -> OutputUtilsKt.writeAll$lambda$0(messageCollector, arg_0, arg_1)));
            }
        }
        catch (NoPermissionException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, string, null, 4, null);
        }
        catch (FileNotFoundException e) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "directory not found: " + outputDir, null, 4, null);
        }
    }

    private static final Unit writeAll$lambda$0(MessageCollector $messageCollector, List sources2, File output2) {
        Intrinsics.checkNotNullParameter((Object)sources2, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        String string = OutputMessageUtil.formatOutputMessage(sources2, output2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatOutputMessage(...)");
        MessageCollector.report$default($messageCollector, CompilerMessageSeverity.OUTPUT, string, null, 4, null);
        return Unit.INSTANCE;
    }
}

