/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.gson;

import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.jetbrains.kotlin.com.google.errorprone.annotations.InlineMe;
import org.jetbrains.kotlin.com.google.gson.ExclusionStrategy;
import org.jetbrains.kotlin.com.google.gson.FieldNamingPolicy;
import org.jetbrains.kotlin.com.google.gson.FieldNamingStrategy;
import org.jetbrains.kotlin.com.google.gson.FormattingStyle;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.InstanceCreator;
import org.jetbrains.kotlin.com.google.gson.JsonDeserializer;
import org.jetbrains.kotlin.com.google.gson.JsonElement;
import org.jetbrains.kotlin.com.google.gson.JsonSerializer;
import org.jetbrains.kotlin.com.google.gson.LongSerializationPolicy;
import org.jetbrains.kotlin.com.google.gson.ReflectionAccessFilter;
import org.jetbrains.kotlin.com.google.gson.Strictness;
import org.jetbrains.kotlin.com.google.gson.ToNumberStrategy;
import org.jetbrains.kotlin.com.google.gson.TypeAdapter;
import org.jetbrains.kotlin.com.google.gson.TypeAdapterFactory;
import org.jetbrains.kotlin.com.google.gson.internal.$Gson$Preconditions;
import org.jetbrains.kotlin.com.google.gson.internal.Excluder;
import org.jetbrains.kotlin.com.google.gson.internal.bind.DefaultDateTypeAdapter;
import org.jetbrains.kotlin.com.google.gson.internal.bind.TreeTypeAdapter;
import org.jetbrains.kotlin.com.google.gson.internal.bind.TypeAdapters;
import org.jetbrains.kotlin.com.google.gson.internal.sql.SqlTypesSupport;
import org.jetbrains.kotlin.com.google.gson.reflect.TypeToken;

public final class GsonBuilder {
    private Excluder excluder = Excluder.DEFAULT;
    private LongSerializationPolicy longSerializationPolicy = LongSerializationPolicy.DEFAULT;
    private FieldNamingStrategy fieldNamingPolicy = FieldNamingPolicy.IDENTITY;
    private final Map<Type, InstanceCreator<?>> instanceCreators = new HashMap();
    private final List<TypeAdapterFactory> factories = new ArrayList<TypeAdapterFactory>();
    private final List<TypeAdapterFactory> hierarchyFactories = new ArrayList<TypeAdapterFactory>();
    private boolean serializeNulls = false;
    private String datePattern = Gson.DEFAULT_DATE_PATTERN;
    private int dateStyle = 2;
    private int timeStyle = 2;
    private boolean complexMapKeySerialization = false;
    private boolean serializeSpecialFloatingPointValues = false;
    private boolean escapeHtmlChars = true;
    private FormattingStyle formattingStyle = Gson.DEFAULT_FORMATTING_STYLE;
    private boolean generateNonExecutableJson = false;
    private Strictness strictness = Gson.DEFAULT_STRICTNESS;
    private boolean useJdkUnsafe = true;
    private ToNumberStrategy objectToNumberStrategy = Gson.DEFAULT_OBJECT_TO_NUMBER_STRATEGY;
    private ToNumberStrategy numberToNumberStrategy = Gson.DEFAULT_NUMBER_TO_NUMBER_STRATEGY;
    private final ArrayDeque<ReflectionAccessFilter> reflectionFilters = new ArrayDeque();

    public GsonBuilder() {
    }

    GsonBuilder(Gson gson2) {
        this.excluder = gson2.excluder;
        this.fieldNamingPolicy = gson2.fieldNamingStrategy;
        this.instanceCreators.putAll(gson2.instanceCreators);
        this.serializeNulls = gson2.serializeNulls;
        this.complexMapKeySerialization = gson2.complexMapKeySerialization;
        this.generateNonExecutableJson = gson2.generateNonExecutableJson;
        this.escapeHtmlChars = gson2.htmlSafe;
        this.formattingStyle = gson2.formattingStyle;
        this.strictness = gson2.strictness;
        this.serializeSpecialFloatingPointValues = gson2.serializeSpecialFloatingPointValues;
        this.longSerializationPolicy = gson2.longSerializationPolicy;
        this.datePattern = gson2.datePattern;
        this.dateStyle = gson2.dateStyle;
        this.timeStyle = gson2.timeStyle;
        this.factories.addAll(gson2.builderFactories);
        this.hierarchyFactories.addAll(gson2.builderHierarchyFactories);
        this.useJdkUnsafe = gson2.useJdkUnsafe;
        this.objectToNumberStrategy = gson2.objectToNumberStrategy;
        this.numberToNumberStrategy = gson2.numberToNumberStrategy;
        this.reflectionFilters.addAll(gson2.reflectionFilters);
    }

    @CanIgnoreReturnValue
    public GsonBuilder setVersion(double version2) {
        if (Double.isNaN(version2) || version2 < 0.0) {
            throw new IllegalArgumentException("Invalid version: " + version2);
        }
        this.excluder = this.excluder.withVersion(version2);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder excludeFieldsWithModifiers(int ... modifiers) {
        Objects.requireNonNull(modifiers);
        this.excluder = this.excluder.withModifiers(modifiers);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder generateNonExecutableJson() {
        this.generateNonExecutableJson = true;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder excludeFieldsWithoutExposeAnnotation() {
        this.excluder = this.excluder.excludeFieldsWithoutExposeAnnotation();
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder serializeNulls() {
        this.serializeNulls = true;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder enableComplexMapKeySerialization() {
        this.complexMapKeySerialization = true;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder disableInnerClassSerialization() {
        this.excluder = this.excluder.disableInnerClassSerialization();
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setLongSerializationPolicy(LongSerializationPolicy serializationPolicy) {
        this.longSerializationPolicy = Objects.requireNonNull(serializationPolicy);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setFieldNamingPolicy(FieldNamingPolicy namingConvention) {
        return this.setFieldNamingStrategy(namingConvention);
    }

    @CanIgnoreReturnValue
    public GsonBuilder setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingPolicy = Objects.requireNonNull(fieldNamingStrategy);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setObjectToNumberStrategy(ToNumberStrategy objectToNumberStrategy) {
        this.objectToNumberStrategy = Objects.requireNonNull(objectToNumberStrategy);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setNumberToNumberStrategy(ToNumberStrategy numberToNumberStrategy) {
        this.numberToNumberStrategy = Objects.requireNonNull(numberToNumberStrategy);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setExclusionStrategies(ExclusionStrategy ... strategies) {
        Objects.requireNonNull(strategies);
        for (ExclusionStrategy strategy : strategies) {
            this.excluder = this.excluder.withExclusionStrategy(strategy, true, true);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder addSerializationExclusionStrategy(ExclusionStrategy strategy) {
        Objects.requireNonNull(strategy);
        this.excluder = this.excluder.withExclusionStrategy(strategy, true, false);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder addDeserializationExclusionStrategy(ExclusionStrategy strategy) {
        Objects.requireNonNull(strategy);
        this.excluder = this.excluder.withExclusionStrategy(strategy, false, true);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setPrettyPrinting() {
        return this.setFormattingStyle(FormattingStyle.PRETTY);
    }

    @CanIgnoreReturnValue
    public GsonBuilder setFormattingStyle(FormattingStyle formattingStyle) {
        this.formattingStyle = Objects.requireNonNull(formattingStyle);
        return this;
    }

    @Deprecated
    @InlineMe(replacement="this.setStrictness(Strictness.LENIENT)", imports={"org.jetbrains.kotlin.com.google.gson.Strictness"})
    @CanIgnoreReturnValue
    public GsonBuilder setLenient() {
        return this.setStrictness(Strictness.LENIENT);
    }

    @CanIgnoreReturnValue
    public GsonBuilder setStrictness(Strictness strictness) {
        this.strictness = Objects.requireNonNull(strictness);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder disableHtmlEscaping() {
        this.escapeHtmlChars = false;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setDateFormat(String pattern) {
        if (pattern != null) {
            try {
                new SimpleDateFormat(pattern);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The date pattern '" + pattern + "' is not valid", e);
            }
        }
        this.datePattern = pattern;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public GsonBuilder setDateFormat(int dateStyle) {
        this.dateStyle = GsonBuilder.checkDateFormatStyle(dateStyle);
        this.datePattern = null;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder setDateFormat(int dateStyle, int timeStyle) {
        this.dateStyle = GsonBuilder.checkDateFormatStyle(dateStyle);
        this.timeStyle = GsonBuilder.checkDateFormatStyle(timeStyle);
        this.datePattern = null;
        return this;
    }

    private static int checkDateFormatStyle(int style) {
        if (style < 0 || style > 3) {
            throw new IllegalArgumentException("Invalid style: " + style);
        }
        return style;
    }

    @CanIgnoreReturnValue
    public GsonBuilder registerTypeAdapter(Type type, Object typeAdapter) {
        Objects.requireNonNull(type);
        $Gson$Preconditions.checkArgument(typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer || typeAdapter instanceof InstanceCreator || typeAdapter instanceof TypeAdapter);
        if (GsonBuilder.isTypeObjectOrJsonElement(type)) {
            throw new IllegalArgumentException("Cannot override built-in adapter for " + type);
        }
        if (typeAdapter instanceof InstanceCreator) {
            this.instanceCreators.put(type, (InstanceCreator)typeAdapter);
        }
        if (typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer) {
            TypeToken<?> typeToken2 = TypeToken.get(type);
            this.factories.add(TreeTypeAdapter.newFactoryWithMatchRawType(typeToken2, typeAdapter));
        }
        if (typeAdapter instanceof TypeAdapter) {
            TypeAdapterFactory factory2 = TypeAdapters.newFactory(TypeToken.get(type), (TypeAdapter)typeAdapter);
            this.factories.add(factory2);
        }
        return this;
    }

    private static boolean isTypeObjectOrJsonElement(Type type) {
        return type instanceof Class && (type == Object.class || JsonElement.class.isAssignableFrom((Class)type));
    }

    @CanIgnoreReturnValue
    public GsonBuilder registerTypeAdapterFactory(TypeAdapterFactory factory2) {
        Objects.requireNonNull(factory2);
        this.factories.add(factory2);
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder registerTypeHierarchyAdapter(Class<?> baseType, Object typeAdapter) {
        Objects.requireNonNull(baseType);
        $Gson$Preconditions.checkArgument(typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer || typeAdapter instanceof TypeAdapter);
        if (JsonElement.class.isAssignableFrom(baseType)) {
            throw new IllegalArgumentException("Cannot override built-in adapter for " + baseType);
        }
        if (typeAdapter instanceof JsonDeserializer || typeAdapter instanceof JsonSerializer) {
            this.hierarchyFactories.add(TreeTypeAdapter.newTypeHierarchyFactory(baseType, typeAdapter));
        }
        if (typeAdapter instanceof TypeAdapter) {
            TypeAdapterFactory factory2 = TypeAdapters.newTypeHierarchyFactory(baseType, (TypeAdapter)typeAdapter);
            this.factories.add(factory2);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder serializeSpecialFloatingPointValues() {
        this.serializeSpecialFloatingPointValues = true;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder disableJdkUnsafe() {
        this.useJdkUnsafe = false;
        return this;
    }

    @CanIgnoreReturnValue
    public GsonBuilder addReflectionAccessFilter(ReflectionAccessFilter filter2) {
        Objects.requireNonNull(filter2);
        this.reflectionFilters.addFirst(filter2);
        return this;
    }

    public Gson create() {
        ArrayList<TypeAdapterFactory> factories = new ArrayList<TypeAdapterFactory>(this.factories.size() + this.hierarchyFactories.size() + 3);
        factories.addAll(this.factories);
        Collections.reverse(factories);
        ArrayList<TypeAdapterFactory> hierarchyFactories = new ArrayList<TypeAdapterFactory>(this.hierarchyFactories);
        Collections.reverse(hierarchyFactories);
        factories.addAll(hierarchyFactories);
        GsonBuilder.addTypeAdaptersForDate(this.datePattern, this.dateStyle, this.timeStyle, factories);
        return new Gson(this.excluder, this.fieldNamingPolicy, new HashMap(this.instanceCreators), this.serializeNulls, this.complexMapKeySerialization, this.generateNonExecutableJson, this.escapeHtmlChars, this.formattingStyle, this.strictness, this.serializeSpecialFloatingPointValues, this.useJdkUnsafe, this.longSerializationPolicy, this.datePattern, this.dateStyle, this.timeStyle, new ArrayList<TypeAdapterFactory>(this.factories), new ArrayList<TypeAdapterFactory>(this.hierarchyFactories), factories, this.objectToNumberStrategy, this.numberToNumberStrategy, new ArrayList<ReflectionAccessFilter>(this.reflectionFilters));
    }

    private static void addTypeAdaptersForDate(String datePattern, int dateStyle, int timeStyle, List<TypeAdapterFactory> factories) {
        TypeAdapterFactory dateAdapterFactory;
        boolean sqlTypesSupported = SqlTypesSupport.SUPPORTS_SQL_TYPES;
        TypeAdapterFactory sqlTimestampAdapterFactory = null;
        TypeAdapterFactory sqlDateAdapterFactory = null;
        if (datePattern != null && !datePattern.trim().isEmpty()) {
            dateAdapterFactory = DefaultDateTypeAdapter.DateType.DATE.createAdapterFactory(datePattern);
            if (sqlTypesSupported) {
                sqlTimestampAdapterFactory = SqlTypesSupport.TIMESTAMP_DATE_TYPE.createAdapterFactory(datePattern);
                sqlDateAdapterFactory = SqlTypesSupport.DATE_DATE_TYPE.createAdapterFactory(datePattern);
            }
        } else if (dateStyle != 2 || timeStyle != 2) {
            dateAdapterFactory = DefaultDateTypeAdapter.DateType.DATE.createAdapterFactory(dateStyle, timeStyle);
            if (sqlTypesSupported) {
                sqlTimestampAdapterFactory = SqlTypesSupport.TIMESTAMP_DATE_TYPE.createAdapterFactory(dateStyle, timeStyle);
                sqlDateAdapterFactory = SqlTypesSupport.DATE_DATE_TYPE.createAdapterFactory(dateStyle, timeStyle);
            }
        } else {
            return;
        }
        factories.add(dateAdapterFactory);
        if (sqlTypesSupported) {
            factories.add(sqlTimestampAdapterFactory);
            factories.add(sqlDateAdapterFactory);
        }
    }
}

