/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.backend.common.serialization;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.gradle.internal.config.CompilerConfiguration;
import org.jetbrains.kotlin.gradle.internal.config.KlibAbiCompatibilityLevel;
import org.jetbrains.kotlin.gradle.internal.config.KlibConfigurationKeys;
import org.jetbrains.kotlin.gradle.internal.config.KlibConfigurationKeysKt;
import org.jetbrains.kotlin.gradle.internal.config.LanguageFeature;
import org.jetbrains.kotlin.gradle.internal.config.LanguageVersionSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/backend/common/serialization/IrSerializationSettings;", "", "configuration", "Lorg/jetbrains/kotlin/gradle/internal/config/CompilerConfiguration;", "languageVersionSettings", "Lorg/jetbrains/kotlin/gradle/internal/config/LanguageVersionSettings;", "publicAbiOnly", "", "bodiesOnlyForInlines", "sourceBaseDirs", "", "", "normalizeAbsolutePaths", "shouldCheckSignaturesOnUniqueness", "reuseExistingSignaturesForSymbols", "abiCompatibilityLevel", "Lorg/jetbrains/kotlin/gradle/internal/config/KlibAbiCompatibilityLevel;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;ZZLjava/util/Collection;ZZZLorg/jetbrains/kotlin/config/KlibAbiCompatibilityLevel;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getPublicAbiOnly", "()Z", "getBodiesOnlyForInlines", "getSourceBaseDirs", "()Ljava/util/Collection;", "getNormalizeAbsolutePaths", "getShouldCheckSignaturesOnUniqueness", "getReuseExistingSignaturesForSymbols", "getAbiCompatibilityLevel", "()Lorg/jetbrains/kotlin/config/KlibAbiCompatibilityLevel;", "ir.serialization.common"})
public final class IrSerializationSettings {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final boolean publicAbiOnly;
    private final boolean bodiesOnlyForInlines;
    @NotNull
    private final Collection<String> sourceBaseDirs;
    private final boolean normalizeAbsolutePaths;
    private final boolean shouldCheckSignaturesOnUniqueness;
    private final boolean reuseExistingSignaturesForSymbols;
    @NotNull
    private final KlibAbiCompatibilityLevel abiCompatibilityLevel;

    public IrSerializationSettings(@NotNull CompilerConfiguration configuration2, @NotNull LanguageVersionSettings languageVersionSettings, boolean publicAbiOnly, boolean bodiesOnlyForInlines, @NotNull Collection<String> sourceBaseDirs, boolean normalizeAbsolutePaths, boolean shouldCheckSignaturesOnUniqueness, boolean reuseExistingSignaturesForSymbols, @NotNull KlibAbiCompatibilityLevel abiCompatibilityLevel) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter(sourceBaseDirs, (String)"sourceBaseDirs");
        Intrinsics.checkNotNullParameter((Object)((Object)abiCompatibilityLevel), (String)"abiCompatibilityLevel");
        this.languageVersionSettings = languageVersionSettings;
        this.publicAbiOnly = publicAbiOnly;
        this.bodiesOnlyForInlines = bodiesOnlyForInlines;
        this.sourceBaseDirs = sourceBaseDirs;
        this.normalizeAbsolutePaths = normalizeAbsolutePaths;
        this.shouldCheckSignaturesOnUniqueness = shouldCheckSignaturesOnUniqueness;
        this.reuseExistingSignaturesForSymbols = reuseExistingSignaturesForSymbols;
        this.abiCompatibilityLevel = abiCompatibilityLevel;
    }

    public /* synthetic */ IrSerializationSettings(CompilerConfiguration compilerConfiguration, LanguageVersionSettings languageVersionSettings, boolean bl, boolean bl2, Collection collection, boolean bl3, boolean bl4, boolean bl5, KlibAbiCompatibilityLevel klibAbiCompatibilityLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(compilerConfiguration);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = bl;
        }
        if ((n & 0x10) != 0) {
            collection = KlibConfigurationKeysKt.getKlibRelativePathBases(compilerConfiguration);
        }
        if ((n & 0x20) != 0) {
            bl3 = KlibConfigurationKeysKt.getKlibNormalizeAbsolutePath(compilerConfiguration);
        }
        if ((n & 0x40) != 0) {
            Boolean bl6 = compilerConfiguration.get(KlibConfigurationKeys.PRODUCE_KLIB_SIGNATURES_CLASH_CHECKS, true);
            Intrinsics.checkNotNullExpressionValue((Object)bl6, (String)"get(...)");
            bl4 = bl6;
        }
        if ((n & 0x80) != 0) {
            bl5 = languageVersionSettings.supportsFeature(LanguageFeature.IrInlinerBeforeKlibSerialization);
        }
        if ((n & 0x100) != 0) {
            klibAbiCompatibilityLevel = KlibConfigurationKeysKt.getKlibAbiCompatibilityLevel(compilerConfiguration);
        }
        this(compilerConfiguration, languageVersionSettings, bl, bl2, collection, bl3, bl4, bl5, klibAbiCompatibilityLevel);
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public final boolean getPublicAbiOnly() {
        return this.publicAbiOnly;
    }

    public final boolean getBodiesOnlyForInlines() {
        return this.bodiesOnlyForInlines;
    }

    @NotNull
    public final Collection<String> getSourceBaseDirs() {
        return this.sourceBaseDirs;
    }

    public final boolean getNormalizeAbsolutePaths() {
        return this.normalizeAbsolutePaths;
    }

    public final boolean getShouldCheckSignaturesOnUniqueness() {
        return this.shouldCheckSignaturesOnUniqueness;
    }

    public final boolean getReuseExistingSignaturesForSymbols() {
        return this.reuseExistingSignaturesForSymbols;
    }

    @NotNull
    public final KlibAbiCompatibilityLevel getAbiCompatibilityLevel() {
        return this.abiCompatibilityLevel;
    }
}

