/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.ide.dependencyResolvers;

import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinDependency;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.ide.IdeDependencyResolver;
import org.jetbrains.kotlin.gradle.plugin.ide.dependencyResolvers.IdeKonanDistributionLibsService;
import org.jetbrains.kotlin.gradle.plugin.ide.dependencyResolvers.IdeKonanDistributionLibsServiceKt;
import org.jetbrains.kotlin.gradle.targets.native.internal.CommonizerTargetKt;
import org.jetbrains.kotlin.gradle.targets.native.internal.CommonizerTasksKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/ide/dependencyResolvers/IdeCommonizedNativePlatformDependencyResolver;", "Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeDependencyResolver;", "Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeDependencyResolver$WithBuildDependencies;", "()V", "dependencies", "", "", "project", "Lorg/gradle/api/Project;", "resolve", "", "Lorg/jetbrains/kotlin/gradle/idea/tcs/IdeaKotlinDependency;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin_common"})
public final class IdeCommonizedNativePlatformDependencyResolver
implements IdeDependencyResolver,
IdeDependencyResolver.WithBuildDependencies {
    @NotNull
    public static final IdeCommonizedNativePlatformDependencyResolver INSTANCE = new IdeCommonizedNativePlatformDependencyResolver();

    private IdeCommonizedNativePlatformDependencyResolver() {
    }

    @Override
    @NotNull
    public Set<IdeaKotlinDependency> resolve(@NotNull KotlinSourceSet sourceSet) {
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Project project = sourceSet.getProject();
        CommonizerTarget commonizerTarget2 = CommonizerTargetKt.getCommonizerTarget(sourceSet).getOrThrow();
        SharedCommonizerTarget sharedCommonizerTarget2 = commonizerTarget2 instanceof SharedCommonizerTarget ? (SharedCommonizerTarget)commonizerTarget2 : null;
        if (sharedCommonizerTarget2 == null) {
            return SetsKt.emptySet();
        }
        SharedCommonizerTarget commonizerTarget3 = sharedCommonizerTarget2;
        Provider<List<File>> provider2 = CommonizerTasksKt.commonizedNativeDistributionKlibsOrNull(project, commonizerTarget3);
        if (provider2 == null) {
            return SetsKt.emptySet();
        }
        Provider<List<File>> klibs = provider2;
        Provider<IdeKonanDistributionLibsService> konanPlatformLibsCacheService = IdeKonanDistributionLibsServiceKt.ideKonanDistributionLibsService(project);
        return ((IdeKonanDistributionLibsService)konanPlatformLibsCacheService.get()).ideDependenciesOfSharedTarget(commonizerTarget3, klibs);
    }

    @Override
    @NotNull
    public Iterable<Object> dependencies(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOfNotNull(CommonizerTasksKt.getCommonizeNativeDistributionTask(project));
    }
}

