/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.zip.ZipException;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ExtraFieldParsingBehavior;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.JarMarker;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ResourceAlignmentExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.UnparseableExtraFieldBehavior;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.UnparseableExtraFieldData;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.X000A_NTFS;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.X0014_X509Certificates;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.X0015_CertificateIdForFile;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.X0016_CertificateIdForCentralDirectory;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.X0017_StrongEncryptionHeader;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.X0019_EncryptionRecipientCertificateList;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.X7875_NewUnix;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static final ConcurrentMap<ZipShort, Supplier<ZipExtraField>> IMPLEMENTATIONS = new ConcurrentHashMap<ZipShort, Supplier<ZipExtraField>>();
    static final ZipExtraField[] EMPTY_ZIP_EXTRA_FIELD_ARRAY;

    public static ZipExtraField createExtraField(ZipShort headerId) {
        ZipExtraField field = ExtraFieldUtils.createExtraFieldNoDefault(headerId);
        if (field != null) {
            return field;
        }
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(headerId);
        return u;
    }

    public static ZipExtraField createExtraFieldNoDefault(ZipShort headerId) {
        Supplier provider2 = (Supplier)IMPLEMENTATIONS.get(headerId);
        return provider2 != null ? (ZipExtraField)provider2.get() : null;
    }

    public static ZipExtraField fillExtraField(ZipExtraField ze, byte[] data, int off, int len, boolean local) throws ZipException {
        try {
            if (local) {
                ze.parseFromLocalFileData(data, off, len);
            } else {
                ze.parseFromCentralDirectoryData(data, off, len);
            }
            return ze;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw (ZipException)new ZipException("Failed to parse corrupt ZIP extra field of type " + Integer.toHexString(ze.getHeaderId().getValue())).initCause(e);
        }
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] data) {
        byte[] central;
        int dataLength = data.length;
        boolean lastIsUnparseableHolder = dataLength > 0 && data[dataLength - 1] instanceof UnparseableExtraFieldData;
        int regularExtraFieldCount = lastIsUnparseableHolder ? dataLength - 1 : dataLength;
        int sum = 4 * regularExtraFieldCount;
        for (ZipExtraField element : data) {
            sum += element.getCentralDirectoryLength().getValue();
        }
        byte[] result2 = new byte[sum];
        int start2 = 0;
        for (int i2 = 0; i2 < regularExtraFieldCount; ++i2) {
            System.arraycopy(data[i2].getHeaderId().getBytes(), 0, result2, start2, 2);
            System.arraycopy(data[i2].getCentralDirectoryLength().getBytes(), 0, result2, start2 + 2, 2);
            start2 += 4;
            byte[] central2 = data[i2].getCentralDirectoryData();
            if (central2 == null) continue;
            System.arraycopy(central2, 0, result2, start2, central2.length);
            start2 += central2.length;
        }
        if (lastIsUnparseableHolder && (central = data[dataLength - 1].getCentralDirectoryData()) != null) {
            System.arraycopy(central, 0, result2, start2, central.length);
        }
        return result2;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] data) {
        byte[] local;
        int dataLength = data.length;
        boolean lastIsUnparseableHolder = dataLength > 0 && data[dataLength - 1] instanceof UnparseableExtraFieldData;
        int regularExtraFieldCount = lastIsUnparseableHolder ? dataLength - 1 : dataLength;
        int sum = 4 * regularExtraFieldCount;
        for (ZipExtraField element : data) {
            sum += element.getLocalFileDataLength().getValue();
        }
        byte[] result2 = new byte[sum];
        int start2 = 0;
        for (int i2 = 0; i2 < regularExtraFieldCount; ++i2) {
            System.arraycopy(data[i2].getHeaderId().getBytes(), 0, result2, start2, 2);
            System.arraycopy(data[i2].getLocalFileDataLength().getBytes(), 0, result2, start2 + 2, 2);
            start2 += 4;
            byte[] local2 = data[i2].getLocalFileDataData();
            if (local2 == null) continue;
            System.arraycopy(local2, 0, result2, start2, local2.length);
            start2 += local2.length;
        }
        if (lastIsUnparseableHolder && (local = data[dataLength - 1].getLocalFileDataData()) != null) {
            System.arraycopy(local, 0, result2, start2, local.length);
        }
        return result2;
    }

    public static ZipExtraField[] parse(byte[] data) throws ZipException {
        return ExtraFieldUtils.parse(data, true, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] data, boolean local) throws ZipException {
        return ExtraFieldUtils.parse(data, local, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] data, boolean local, ExtraFieldParsingBehavior parsingBehavior) throws ZipException {
        int length;
        ArrayList<ZipExtraField> v = new ArrayList<ZipExtraField>();
        int dataLength = data.length;
        for (int start2 = 0; start2 <= dataLength - 4; start2 += length + 4) {
            ZipShort headerId = new ZipShort(data, start2);
            length = new ZipShort(data, start2 + 2).getValue();
            if (start2 + 4 + length > dataLength) {
                ZipExtraField field = parsingBehavior.onUnparseableExtraField(data, start2, dataLength - start2, local, length);
                if (field == null) break;
                v.add(field);
                break;
            }
            try {
                ZipExtraField ze = Objects.requireNonNull(parsingBehavior.createExtraField(headerId), "createExtraField must not return null");
                v.add(Objects.requireNonNull(parsingBehavior.fill(ze, data, start2 + 4, length, local), "fill must not return null"));
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw (ZipException)new ZipException(e.getMessage()).initCause(e);
            }
        }
        return v.toArray(EMPTY_ZIP_EXTRA_FIELD_ARRAY);
    }

    public static ZipExtraField[] parse(byte[] data, boolean local, final UnparseableExtraField onUnparseableData) throws ZipException {
        return ExtraFieldUtils.parse(data, local, new ExtraFieldParsingBehavior(){

            @Override
            public ZipExtraField createExtraField(ZipShort headerId) {
                return ExtraFieldUtils.createExtraField(headerId);
            }

            @Override
            public ZipExtraField fill(ZipExtraField field, byte[] data, int off, int len, boolean local) throws ZipException {
                return ExtraFieldUtils.fillExtraField(field, data, off, len, local);
            }

            @Override
            public ZipExtraField onUnparseableExtraField(byte[] data, int off, int len, boolean local, int claimedLength) throws ZipException {
                return onUnparseableData.onUnparseableExtraField(data, off, len, local, claimedLength);
            }
        });
    }

    @Deprecated
    public static void register(Class<?> clazz) {
        try {
            Constructor<ZipExtraField> constructor = clazz.asSubclass(ZipExtraField.class).getConstructor(new Class[0]);
            ZipExtraField zef = clazz.asSubclass(ZipExtraField.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            IMPLEMENTATIONS.put(zef.getHeaderId(), () -> {
                try {
                    return (ZipExtraField)constructor.newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException(clazz.toString(), e);
                }
            });
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(clazz.toString(), e);
        }
    }

    static {
        IMPLEMENTATIONS.put(AsiExtraField.HEADER_ID, AsiExtraField::new);
        IMPLEMENTATIONS.put(X5455_ExtendedTimestamp.HEADER_ID, X5455_ExtendedTimestamp::new);
        IMPLEMENTATIONS.put(X7875_NewUnix.HEADER_ID, X7875_NewUnix::new);
        IMPLEMENTATIONS.put(JarMarker.ID, JarMarker::new);
        IMPLEMENTATIONS.put(UnicodePathExtraField.UPATH_ID, UnicodePathExtraField::new);
        IMPLEMENTATIONS.put(UnicodeCommentExtraField.UCOM_ID, UnicodeCommentExtraField::new);
        IMPLEMENTATIONS.put(Zip64ExtendedInformationExtraField.HEADER_ID, Zip64ExtendedInformationExtraField::new);
        IMPLEMENTATIONS.put(X000A_NTFS.HEADER_ID, X000A_NTFS::new);
        IMPLEMENTATIONS.put(X0014_X509Certificates.HEADER_ID, X0014_X509Certificates::new);
        IMPLEMENTATIONS.put(X0015_CertificateIdForFile.HEADER_ID, X0015_CertificateIdForFile::new);
        IMPLEMENTATIONS.put(X0016_CertificateIdForCentralDirectory.HEADER_ID, X0016_CertificateIdForCentralDirectory::new);
        IMPLEMENTATIONS.put(X0017_StrongEncryptionHeader.HEADER_ID, X0017_StrongEncryptionHeader::new);
        IMPLEMENTATIONS.put(X0019_EncryptionRecipientCertificateList.HEADER_ID, X0019_EncryptionRecipientCertificateList::new);
        IMPLEMENTATIONS.put(ResourceAlignmentExtraField.ID, ResourceAlignmentExtraField::new);
        EMPTY_ZIP_EXTRA_FIELD_ARRAY = new ZipExtraField[0];
    }

    public static final class UnparseableExtraField
    implements UnparseableExtraFieldBehavior {
        public static final int THROW_KEY = 0;
        public static final int SKIP_KEY = 1;
        public static final int READ_KEY = 2;
        public static final UnparseableExtraField THROW = new UnparseableExtraField(0);
        public static final UnparseableExtraField SKIP = new UnparseableExtraField(1);
        public static final UnparseableExtraField READ = new UnparseableExtraField(2);
        private final int key;

        private UnparseableExtraField(int k) {
            this.key = k;
        }

        public int getKey() {
            return this.key;
        }

        @Override
        public ZipExtraField onUnparseableExtraField(byte[] data, int off, int len, boolean local, int claimedLength) throws ZipException {
            switch (this.key) {
                case 0: {
                    throw new ZipException("Bad extra field starting at " + off + ".  Block length of " + claimedLength + " bytes exceeds remaining data of " + (len - 4) + " bytes.");
                }
                case 2: {
                    UnparseableExtraFieldData field = new UnparseableExtraFieldData();
                    if (local) {
                        field.parseFromLocalFileData(data, off, len);
                    } else {
                        field.parseFromCentralDirectoryData(data, off, len);
                    }
                    return field;
                }
                case 1: {
                    return null;
                }
            }
            throw new ZipException("Unknown UnparseableExtraField key: " + this.key);
        }
    }
}

