/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.changes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.ArchiveEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.ArchiveInputStream;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.zip.ZipFile;
import org.jetbrains.kotlin.org.apache.commons.compress.changes.Change;
import org.jetbrains.kotlin.org.apache.commons.compress.changes.ChangeSet;
import org.jetbrains.kotlin.org.apache.commons.compress.changes.ChangeSetResults;
import org.jetbrains.kotlin.org.apache.commons.io.IOUtils;

public class ChangeSetPerformer<I extends ArchiveInputStream<E>, O extends ArchiveOutputStream<E>, E extends ArchiveEntry> {
    private final Set<Change<E>> changes;

    public ChangeSetPerformer(ChangeSet<E> changeSet) {
        this.changes = changeSet.getChanges();
    }

    private void copyStream(InputStream inputStream, O outputStream, E archiveEntry) throws IOException {
        ((ArchiveOutputStream)outputStream).putArchiveEntry(archiveEntry);
        IOUtils.copy(inputStream, outputStream);
        ((ArchiveOutputStream)outputStream).closeArchiveEntry();
    }

    private boolean isDeletedLater(Set<Change<E>> workingSet, E entry2) {
        String source2 = entry2.getName();
        if (!workingSet.isEmpty()) {
            for (Change<E> change : workingSet) {
                Change.ChangeType type = change.getType();
                String target2 = change.getTargetFileName();
                if (type == Change.ChangeType.DELETE && source2.equals(target2)) {
                    return true;
                }
                if (type != Change.ChangeType.DELETE_DIR || !source2.startsWith(target2 + "/")) continue;
                return true;
            }
        }
        return false;
    }

    private ChangeSetResults perform(ArchiveEntryIterator<E> entryIterator, O outputStream) throws IOException {
        InputStream inputStream;
        ChangeSetResults results = new ChangeSetResults();
        LinkedHashSet<Change<E>> workingSet = new LinkedHashSet<Change<E>>(this.changes);
        Iterator it = workingSet.iterator();
        while (it.hasNext()) {
            Change change = (Change)it.next();
            if (change.getType() != Change.ChangeType.ADD || !change.isReplaceMode()) continue;
            inputStream = change.getInputStream();
            this.copyStream(inputStream, outputStream, change.getEntry());
            it.remove();
            results.addedFromChangeSet(change.getEntry().getName());
        }
        while (entryIterator.hasNext()) {
            E entry2 = entryIterator.next();
            boolean copy2 = true;
            Iterator it2 = workingSet.iterator();
            while (it2.hasNext()) {
                Change change = (Change)it2.next();
                Change.ChangeType type = change.getType();
                String name2 = entry2.getName();
                if (type == Change.ChangeType.DELETE && name2 != null) {
                    if (!name2.equals(change.getTargetFileName())) continue;
                    copy2 = false;
                    it2.remove();
                    results.deleted(name2);
                    break;
                }
                if (type != Change.ChangeType.DELETE_DIR || name2 == null || !name2.startsWith(change.getTargetFileName() + "/")) continue;
                copy2 = false;
                results.deleted(name2);
                break;
            }
            if (!copy2 || this.isDeletedLater(workingSet, entry2) || results.hasBeenAdded(entry2.getName())) continue;
            inputStream = entryIterator.getInputStream();
            this.copyStream(inputStream, outputStream, entry2);
            results.addedFromStream(entry2.getName());
        }
        it = workingSet.iterator();
        while (it.hasNext()) {
            Change change = (Change)it.next();
            if (change.getType() != Change.ChangeType.ADD || change.isReplaceMode() || results.hasBeenAdded(change.getEntry().getName())) continue;
            InputStream input = change.getInputStream();
            this.copyStream(input, outputStream, change.getEntry());
            it.remove();
            results.addedFromChangeSet(change.getEntry().getName());
        }
        ((ArchiveOutputStream)outputStream).finish();
        return results;
    }

    public ChangeSetResults perform(I inputStream, O outputStream) throws IOException {
        return this.perform((I)new ArchiveInputStreamIterator(inputStream), outputStream);
    }

    public ChangeSetResults perform(ZipFile zipFile, O outputStream) throws IOException {
        ZipFileIterator entryIterator = new ZipFileIterator(zipFile);
        return this.perform((I)entryIterator, outputStream);
    }

    private static interface ArchiveEntryIterator<E extends ArchiveEntry> {
        public InputStream getInputStream() throws IOException;

        public boolean hasNext() throws IOException;

        public E next();
    }

    private static final class ArchiveInputStreamIterator<E extends ArchiveEntry>
    implements ArchiveEntryIterator<E> {
        private final ArchiveInputStream<E> inputStream;
        private E next;

        ArchiveInputStreamIterator(ArchiveInputStream<E> inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public boolean hasNext() throws IOException {
            this.next = this.inputStream.getNextEntry();
            return this.next != null;
        }

        @Override
        public E next() {
            return this.next;
        }
    }

    private static final class ZipFileIterator
    implements ArchiveEntryIterator<ZipArchiveEntry> {
        private final ZipFile zipFile;
        private final Enumeration<ZipArchiveEntry> nestedEnumeration;
        private ZipArchiveEntry currentEntry;

        ZipFileIterator(ZipFile zipFile) {
            this.zipFile = zipFile;
            this.nestedEnumeration = zipFile.getEntriesInPhysicalOrder();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.zipFile.getInputStream(this.currentEntry);
        }

        @Override
        public boolean hasNext() {
            return this.nestedEnumeration.hasMoreElements();
        }

        @Override
        public ZipArchiveEntry next() {
            this.currentEntry = this.nestedEnumeration.nextElement();
            return this.currentEntry;
        }
    }
}

