/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.io.comparator;

import java.io.File;
import java.io.Serializable;
import java.util.Comparator;
import org.jetbrains.kotlin.org.apache.commons.io.FileUtils;
import org.jetbrains.kotlin.org.apache.commons.io.comparator.AbstractFileComparator;
import org.jetbrains.kotlin.org.apache.commons.io.comparator.ReverseFileComparator;

public class LastModifiedFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final long serialVersionUID = 7372168004395734046L;
    public static final Comparator<File> LASTMODIFIED_COMPARATOR = new LastModifiedFileComparator();
    public static final Comparator<File> LASTMODIFIED_REVERSE = new ReverseFileComparator(LASTMODIFIED_COMPARATOR);

    @Override
    public int compare(File file1, File file2) {
        long result2 = FileUtils.lastModifiedUnchecked(file1) - FileUtils.lastModifiedUnchecked(file2);
        if (result2 < 0L) {
            return -1;
        }
        if (result2 > 0L) {
            return 1;
        }
        return 0;
    }
}

