/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.gradle.internal.progress.CompilationCanceledException;
import org.jetbrains.kotlin.gradle.internal.progress.IncrementalNextRoundException;

@Metadata(k=2, mv={2, 2, 0}, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001aG\u0010\t\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0011\u0010\f\u001a\u00020\u0002*\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0019\u0010\u0011\u001a\u00020\u0010*\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "messageCollector", "", "useK2", "", "", "pluginClasspaths", "pluginOptions", "pluginConfigurations", "checkPluginsArguments", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;ZLjava/util/List;Ljava/util/List;Ljava/util/List;)Z", "", "hasOOMCause", "(Ljava/lang/Throwable;)Z", "Lorg/jetbrains/kotlin/gradle/internal/progress/CompilationCanceledException;", "e", "", "reportCompilationCancelled", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/gradle/internal/progress/CompilationCanceledException;)V", "cli"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\nCLICompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLICompiler.kt\norg/jetbrains/kotlin/cli/common/CLICompilerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,502:1\n1915#2,2:503\n1915#2,2:505\n*S KotlinDebug\n*F\n+ 1 CLICompiler.kt\norg/jetbrains/kotlin/cli/common/CLICompilerKt\n*L\n478#1:503,2\n482#1:505,2\n*E\n"})
public final class CLICompilerKt {
    public static final boolean checkPluginsArguments(@NotNull MessageCollector messageCollector, boolean useK2, @NotNull List<String> pluginClasspaths, @NotNull List<String> pluginOptions, @NotNull List<String> pluginConfigurations) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter(pluginClasspaths, (String)"pluginClasspaths");
        Intrinsics.checkNotNullParameter(pluginOptions, (String)"pluginOptions");
        Intrinsics.checkNotNullParameter(pluginConfigurations, (String)"pluginConfigurations");
        boolean hasErrors = false;
        for (String classpath2 : pluginClasspaths) {
            if (new File(classpath2).exists()) continue;
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Plugin classpath entry points to a non-existent location: " + classpath2, null, 4, null);
        }
        if (!((Collection)pluginConfigurations).isEmpty()) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.WARNING, "Argument -Xcompiler-plugin is experimental", null, 4, null);
            if (!useK2) {
                hasErrors = true;
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "-Xcompiler-plugin argument is allowed only for language version 2.0. Please use -Xplugin argument for language version 1.9 and below", null, 4, null);
            }
            if (!((Collection)pluginClasspaths).isEmpty() || !((Collection)pluginOptions).isEmpty()) {
                String it;
                StringBuilder stringBuilder;
                hasErrors = true;
                StringBuilder $this$checkPluginsArguments_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$checkPluginsArguments_u24lambda_u240.append("Mixing legacy and modern plugin arguments is prohibited. Please use only one syntax").append('\n');
                $this$checkPluginsArguments_u24lambda_u240.append("Legacy arguments:").append('\n');
                if (!((Collection)pluginClasspaths).isEmpty()) {
                    $this$checkPluginsArguments_u24lambda_u240.append("  -Xplugin=" + CollectionsKt.joinToString$default((Iterable)pluginClasspaths, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append('\n');
                }
                Iterable $this$forEach$iv = pluginOptions;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl2 = false;
                    $this$checkPluginsArguments_u24lambda_u240.append("  -P " + it).append('\n');
                }
                $this$checkPluginsArguments_u24lambda_u240.append("Modern arguments:").append('\n');
                $this$forEach$iv = pluginConfigurations;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl3 = false;
                    $this$checkPluginsArguments_u24lambda_u240.append("  -Xcompiler-plugin=" + it).append('\n');
                }
                String message2 = stringBuilder.toString();
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, message2, null, 4, null);
            }
        }
        return !hasErrors;
    }

    public static final boolean hasOOMCause(@NotNull Throwable $this$hasOOMCause) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasOOMCause, (String)"<this>");
        if ($this$hasOOMCause.getCause() instanceof OutOfMemoryError) {
            bl = true;
        } else {
            Throwable throwable = $this$hasOOMCause.getCause();
            bl = throwable != null ? CLICompilerKt.hasOOMCause(throwable) : false;
        }
        return bl;
    }

    public static final void reportCompilationCancelled(@NotNull MessageCollector $this$reportCompilationCancelled, @NotNull CompilationCanceledException e) {
        Intrinsics.checkNotNullParameter((Object)$this$reportCompilationCancelled, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        if (!(e instanceof IncrementalNextRoundException)) {
            $this$reportCompilationCancelled.report(CompilerMessageSeverity.INFO, "Compilation was canceled", null);
        }
    }
}

