/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.AdditionalRootsProviderService;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.jps.build.KotlinIncludedModuleSourceRoot;
import org.jetbrains.kotlin.jps.build.KotlinSourceRootProviderKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinSourceRootProvider;", "Lorg/jetbrains/jps/builders/AdditionalRootsProviderService;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "()V", "addModuleSourceRoots", "", "result", "", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "getAdditionalRoots", "", "Lorg/jetbrains/jps/builders/BuildTarget;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "jps-plugin"})
public final class KotlinSourceRootProvider
extends AdditionalRootsProviderService<JavaSourceRootDescriptor> {
    public KotlinSourceRootProvider() {
        super((Collection)JavaModuleBuildTargetType.ALL_TYPES);
    }

    @NotNull
    public List<JavaSourceRootDescriptor> getAdditionalRoots(@NotNull BuildTarget<JavaSourceRootDescriptor> target, @Nullable BuildDataPaths dataPaths) {
        ModuleBuildTarget moduleBuildTarget;
        Intrinsics.checkNotNullParameter(target, (String)"target");
        ModuleBuildTarget moduleBuildTarget2 = moduleBuildTarget = target instanceof ModuleBuildTarget ? (ModuleBuildTarget)target : null;
        if (moduleBuildTarget == null) {
            return CollectionsKt.emptyList();
        }
        ModuleBuildTarget moduleBuildTarget3 = moduleBuildTarget;
        JpsModule jpsModule = moduleBuildTarget3.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"moduleBuildTarget.module");
        JpsModule module = jpsModule;
        List result = new ArrayList();
        KotlinSourceRootType kotlinSourceRootType = ((ModuleBuildTarget)target).isTests() ? (KotlinSourceRootType)TestSourceKotlinRootType.INSTANCE : (KotlinSourceRootType)SourceKotlinRootType.INSTANCE;
        Iterable iterable = module.getSourceRoots((JpsModuleSourceRootType)kotlinSourceRootType);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"module.getSourceRoots(kotlinSourceRootType)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsTypedModuleSourceRoot it = (JpsTypedModuleSourceRoot)element$iv;
            boolean bl = false;
            result.add(new JavaSourceRootDescriptor(it.getFile(), (ModuleBuildTarget)target, false, false, ((JavaSourceRootProperties)it.getProperties()).getPackagePrefix(), SetsKt.emptySet()));
        }
        if (((ModuleBuildTarget)target).isTests() == ModuleSettingsKt.isTestModule(module)) {
            $this$forEach$iv = ModuleSettingsKt.getSourceSetModules(module);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JpsModule sourceSetModule = (JpsModule)element$iv;
                boolean bl = false;
                this.addModuleSourceRoots(result, sourceSetModule, (ModuleBuildTarget)target);
            }
        }
        $this$forEach$iv = ModuleSettingsKt.getExpectedByModules(module);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsModule commonModule = (JpsModule)element$iv;
            boolean bl = false;
            this.addModuleSourceRoots(result, commonModule, (ModuleBuildTarget)target);
        }
        return result;
    }

    private final void addModuleSourceRoots(List<JavaSourceRootDescriptor> result, JpsModule module, ModuleBuildTarget target) {
        for (JpsModuleSourceRoot commonSourceRoot : module.getSourceRoots()) {
            JpsModuleSourceRootType jpsModuleSourceRootType = commonSourceRoot.getRootType();
            Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRootType, (String)"commonSourceRoot.rootType");
            Boolean isCommonTestsRootType = KotlinSourceRootProviderKt.access$isTestsRootType(jpsModuleSourceRootType);
            if (isCommonTestsRootType == null || !Intrinsics.areEqual((Object)target.isTests(), (Object)isCommonTestsRootType)) continue;
            Object object = commonSourceRoot.getProperties();
            JavaSourceRootProperties javaSourceRootProperties = object instanceof JavaSourceRootProperties ? (JavaSourceRootProperties)object : null;
            object = commonSourceRoot.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"commonSourceRoot.file");
            Object object2 = object;
            object = javaSourceRootProperties;
            boolean bl = object == null ? false : object.isForGeneratedSources();
            JavaSourceRootProperties javaSourceRootProperties2 = javaSourceRootProperties;
            object = javaSourceRootProperties2 == null ? "" : javaSourceRootProperties2.getPackagePrefix();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaSourceRootProperties?.packagePrefix ?: \"\"");
            result.add(new KotlinIncludedModuleSourceRoot((File)object2, target, bl, false, (String)object, SetsKt.emptySet()));
        }
    }
}

