/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.DirtyFilesHolderBase;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.incremental.BuildOperations;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolderKt;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001,B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J&\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 J\u0014\u0010!\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#J\u001b\u0010$\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0000\u00a2\u0006\u0002\b%J\u001c\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0&J3\u0010'\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#2\u0006\u0010(\u001a\u00020\u000e2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000e0*H\u0082\bJ\"\u0010+\u001a\u00020\u00152\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper;", "", "compileContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "dirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/jps/ModuleChunk;Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;Lcom/intellij/openapi/diagnostic/Logger;)V", "buildLogger", "Lorg/jetbrains/kotlin/jps/build/TestingBuildLogger;", "<set-?>", "", "hasMarkedDirty", "getHasMarkedDirty$jps_plugin", "()Z", "moduleBasedFilter", "Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper$ModulesBasedFileFilter;", "cleanOutputsForNewDirtyFilesInCurrentRound", "", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "dirtyFiles", "", "Ljava/io/File;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "markChunk", "recursively", "kotlinOnly", "excludeFiles", "", "markFiles", "files", "", "markFilesForCurrentRound", "markFilesForCurrentRound$jps_plugin", "", "markFilesImpl", "currentRound", "shouldMark", "Lkotlin/Function1;", "markInChunkOrDependents", "ModulesBasedFileFilter", "jps-plugin"})
public final class FSOperationsHelper {
    @NotNull
    private final CompileContext compileContext;
    @NotNull
    private final ModuleChunk chunk;
    @NotNull
    private final KotlinDirtySourceFilesHolder dirtyFilesHolder;
    @NotNull
    private final Logger log;
    @NotNull
    private final ModulesBasedFileFilter moduleBasedFilter;
    private boolean hasMarkedDirty;
    @Nullable
    private final TestingBuildLogger buildLogger;

    public FSOperationsHelper(@NotNull CompileContext compileContext, @NotNull ModuleChunk chunk, @NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)compileContext, (String)"compileContext");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.compileContext = compileContext;
        this.chunk = chunk;
        this.dirtyFilesHolder = dirtyFilesHolder2;
        this.log = log;
        this.moduleBasedFilter = new ModulesBasedFileFilter(this.compileContext, this.chunk);
        TestingContext testingContext = TestingContextKt.getTestingContext(this.compileContext);
        this.buildLogger = testingContext != null ? testingContext.getBuildLogger() : null;
    }

    public final boolean getHasMarkedDirty$jps_plugin() {
        return this.hasMarkedDirty;
    }

    public final void markChunk(boolean recursively, boolean kotlinOnly, @NotNull Set<? extends File> excludeFiles) {
        Intrinsics.checkNotNullParameter(excludeFiles, (String)"excludeFiles");
        if (recursively) {
            FSOperations.markDirtyRecursively((CompileContext)this.compileContext, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.chunk, arg_0 -> FSOperationsHelper.markChunk$shouldMark(kotlinOnly, excludeFiles, this, arg_0));
        } else {
            FSOperations.markDirty((CompileContext)this.compileContext, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.chunk, arg_0 -> FSOperationsHelper.markChunk$shouldMark(kotlinOnly, excludeFiles, this, arg_0));
        }
    }

    public static /* synthetic */ void markChunk$default(FSOperationsHelper fSOperationsHelper, boolean bl, boolean bl2, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        fSOperationsHelper.markChunk(bl, bl2, set);
    }

    /*
     * WARNING - void declaration
     */
    public final void markFilesForCurrentRound$jps_plugin(@NotNull Iterable<? extends File> files) {
        void $this$filterTo$iv$iv;
        Object element$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Object $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        Iterator<? extends File> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            File it = element$iv;
            boolean bl = false;
            JavaSourceRootDescriptor root = this.compileContext.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(this.compileContext, it);
            if (root == null) continue;
            KotlinDirtySourceFilesHolder.TargetFiles targetFiles = this.dirtyFilesHolder.getByTarget().get(root.target);
            if (targetFiles == null) continue;
            targetFiles._markDirty$jps_plugin(it, root);
        }
        $this$forEach$iv = this;
        boolean currentRound$iv = true;
        boolean $i$f$markFilesImpl = false;
        element$iv = files;
        Collection destination$iv$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(it.exists() && this.moduleBasedFilter.accept(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HashSet filesToMark$iv = (HashSet)destination$iv$iv;
        if (!filesToMark$iv.isEmpty()) {
            void this_$iv;
            TestingBuildLogger testingBuildLogger = this_$iv.buildLogger;
            if (testingBuildLogger != null) {
                testingBuildLogger.markedAsDirtyBeforeRound(filesToMark$iv);
            }
            CompilationRound compilationRound$iv = CompilationRound.CURRENT;
            for (File fileToMark$iv : filesToMark$iv) {
                FSOperations.markDirty((CompileContext)this_$iv.compileContext, (CompilationRound)compilationRound$iv, (File)fileToMark$iv);
            }
            this_$iv.log.debug("Mark dirty: " + filesToMark$iv + " (" + compilationRound$iv + ')');
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void markFilesForCurrentRound(@NotNull ModuleBuildTarget target, @NotNull Collection<? extends File> files) {
        void $this$filterTo$iv$iv;
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (!this.chunk.getTargets().contains(target)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KotlinDirtySourceFilesHolder.TargetFiles targetDirtyFiles2 = (KotlinDirtySourceFilesHolder.TargetFiles)MapsKt.getValue(this.dirtyFilesHolder.getByTarget(), (Object)target);
        HashMap dirtyFileToRoot = new HashMap();
        Object $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            BuildRootDescriptor root;
            void $this$single$iv;
            element$iv = iterator2.next();
            File file = (File)element$iv;
            boolean bl = false;
            Collection collection = this.compileContext.getProjectDescriptor().getBuildRootIndex().findAllParentDescriptors(file, this.compileContext);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"compileContext.projectDe\u2026or>(file, compileContext)");
            Iterable iterable = collection;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv2 : $this$single$iv) {
                BuildRootDescriptor sourceRoot = (BuildRootDescriptor)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)sourceRoot.getTarget(), (Object)target)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv2;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            BuildRootDescriptor buildRootDescriptor = root = (BuildRootDescriptor)single$iv;
            if (buildRootDescriptor == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.jps.builders.java.JavaSourceRootDescriptor");
            }
            targetDirtyFiles2._markDirty$jps_plugin(file, (JavaSourceRootDescriptor)buildRootDescriptor);
            ((Map)dirtyFileToRoot).put(file, root);
        }
        $this$forEach$iv = this;
        boolean currentRound$iv = true;
        boolean $i$f$markFilesImpl = false;
        element$iv = files;
        Collection destination$iv$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HashSet filesToMark$iv = (HashSet)destination$iv$iv;
        if (!filesToMark$iv.isEmpty()) {
            void this_$iv;
            TestingBuildLogger testingBuildLogger = this_$iv.buildLogger;
            if (testingBuildLogger != null) {
                testingBuildLogger.markedAsDirtyBeforeRound(filesToMark$iv);
            }
            CompilationRound compilationRound$iv = CompilationRound.CURRENT;
            for (File fileToMark$iv : filesToMark$iv) {
                FSOperations.markDirty((CompileContext)this_$iv.compileContext, (CompilationRound)compilationRound$iv, (File)fileToMark$iv);
            }
            this_$iv.log.debug("Mark dirty: " + filesToMark$iv + " (" + compilationRound$iv + ')');
        }
        this.cleanOutputsForNewDirtyFilesInCurrentRound(target, dirtyFileToRoot);
    }

    private final void cleanOutputsForNewDirtyFilesInCurrentRound(ModuleBuildTarget target, Map<File, ? extends JavaSourceRootDescriptor> dirtyFiles) {
        CompileContext compileContext = this.compileContext;
        DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2 = new DirtyFilesHolderBase<JavaSourceRootDescriptor, ModuleBuildTarget>(dirtyFiles, target, compileContext){
            final /* synthetic */ Map<File, JavaSourceRootDescriptor> $dirtyFiles;
            final /* synthetic */ ModuleBuildTarget $target;
            {
                this.$dirtyFiles = $dirtyFiles;
                this.$target = $target;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void processDirtyFiles(@NotNull FileProcessor<JavaSourceRootDescriptor, ModuleBuildTarget> processor) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(processor, (String)"processor");
                Map<File, JavaSourceRootDescriptor> map = this.$dirtyFiles;
                ModuleBuildTarget moduleBuildTarget = this.$target;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator2.next();
                    boolean bl = false;
                    File file = (File)entry.getKey();
                    JavaSourceRootDescriptor root = (JavaSourceRootDescriptor)entry.getValue();
                    processor.apply((BuildTarget)moduleBuildTarget, file, (BuildRootDescriptor)root);
                }
            }

            public boolean hasDirtyFiles() {
                return !this.$dirtyFiles.isEmpty();
            }
        };
        BuildOperations.cleanOutputsCorrespondingToChangedFiles((CompileContext)this.compileContext, (DirtyFilesHolder)((DirtyFilesHolder)dirtyFilesHolder2));
    }

    /*
     * WARNING - void declaration
     */
    public final void markFiles(@NotNull Iterable<? extends File> files) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        FSOperationsHelper fSOperationsHelper = this;
        boolean currentRound$iv = false;
        boolean $i$f$markFilesImpl = false;
        Iterable<? extends File> iterable = files;
        Collection destination$iv$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HashSet filesToMark$iv = (HashSet)destination$iv$iv;
        if (!filesToMark$iv.isEmpty()) {
            void this_$iv;
            TestingBuildLogger testingBuildLogger = this_$iv.buildLogger;
            if (testingBuildLogger != null) {
                testingBuildLogger.markedAsDirtyAfterRound(filesToMark$iv);
            }
            this_$iv.hasMarkedDirty = true;
            CompilationRound compilationRound$iv = CompilationRound.NEXT;
            for (File fileToMark$iv : filesToMark$iv) {
                FSOperations.markDirty((CompileContext)this_$iv.compileContext, (CompilationRound)compilationRound$iv, (File)fileToMark$iv);
            }
            this_$iv.log.debug("Mark dirty: " + filesToMark$iv + " (" + compilationRound$iv + ')');
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void markInChunkOrDependents(@NotNull Iterable<? extends File> files, @NotNull Set<? extends File> excludeFiles) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(excludeFiles, (String)"excludeFiles");
        FSOperationsHelper fSOperationsHelper = this;
        boolean currentRound$iv = false;
        boolean $i$f$markFilesImpl = false;
        Iterable<? extends File> iterable = files;
        Collection destination$iv$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!(!excludeFiles.contains(it) && it.exists() && this.moduleBasedFilter.accept(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        HashSet filesToMark$iv = (HashSet)destination$iv$iv;
        if (!filesToMark$iv.isEmpty()) {
            void this_$iv;
            TestingBuildLogger testingBuildLogger = this_$iv.buildLogger;
            if (testingBuildLogger != null) {
                testingBuildLogger.markedAsDirtyAfterRound(filesToMark$iv);
            }
            this_$iv.hasMarkedDirty = true;
            CompilationRound compilationRound$iv = CompilationRound.NEXT;
            for (File fileToMark$iv : filesToMark$iv) {
                FSOperations.markDirty((CompileContext)this_$iv.compileContext, (CompilationRound)compilationRound$iv, (File)fileToMark$iv);
            }
            this_$iv.log.debug("Mark dirty: " + filesToMark$iv + " (" + compilationRound$iv + ')');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void markFilesImpl(Iterable<? extends File> files, boolean currentRound, Function1<? super File, Boolean> shouldMark) {
        CompilationRound compilationRound;
        void $this$filterTo$iv;
        boolean $i$f$markFilesImpl = false;
        Iterable<? extends File> iterable = files;
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            if (!((Boolean)shouldMark.invoke(element$iv)).booleanValue()) continue;
            destination$iv.add(element$iv);
        }
        HashSet filesToMark = (HashSet)destination$iv;
        if (filesToMark.isEmpty()) {
            return;
        }
        if (currentRound) {
            TestingBuildLogger testingBuildLogger = this.buildLogger;
            if (testingBuildLogger != null) {
                testingBuildLogger.markedAsDirtyBeforeRound(filesToMark);
            }
            compilationRound = CompilationRound.CURRENT;
        } else {
            TestingBuildLogger testingBuildLogger = this.buildLogger;
            if (testingBuildLogger != null) {
                testingBuildLogger.markedAsDirtyAfterRound(filesToMark);
            }
            this.hasMarkedDirty = true;
            compilationRound = CompilationRound.NEXT;
        }
        CompilationRound compilationRound2 = compilationRound;
        for (File fileToMark : filesToMark) {
            FSOperations.markDirty((CompileContext)this.compileContext, (CompilationRound)compilationRound2, (File)fileToMark);
        }
        this.log.debug("Mark dirty: " + filesToMark + " (" + compilationRound2 + ')');
    }

    private static final boolean markChunk$shouldMark(boolean $kotlinOnly, Set<? extends File> $excludeFiles, FSOperationsHelper this$0, File file) {
        if ($kotlinOnly && !KotlinDirtySourceFilesHolderKt.isKotlinSourceFile(file)) {
            return false;
        }
        if ($excludeFiles.contains(file)) {
            return false;
        }
        this$0.hasMarkedDirty = true;
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J*\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u000f*\u00020\u000b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RF\u0010\f\u001a:\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u000f0\rj\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00130\u0013 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u000f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/jps/build/FSOperationsHelper$ModulesBasedFileFilter;", "Lorg/jetbrains/jps/builders/java/dependencyView/Mappings$DependentFilesFilter;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "(Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/jps/ModuleChunk;)V", "buildRootIndex", "Lorg/jetbrains/jps/builders/BuildRootIndex;", "kotlin.jvm.PlatformType", "buildTargetIndex", "Lorg/jetbrains/jps/builders/BuildTargetIndex;", "cache", "Ljava/util/HashMap;", "Lorg/jetbrains/jps/builders/BuildTarget;", "", "Lkotlin/collections/HashMap;", "chunkTargets", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "accept", "", "file", "Ljava/io/File;", "belongsToCurrentTargetChunk", "myGetDependenciesRecursively", "target", "jps-plugin"})
    private static final class ModulesBasedFileFilter
    implements Mappings.DependentFilesFilter {
        @NotNull
        private final CompileContext context;
        private final Set<ModuleBuildTarget> chunkTargets;
        private final BuildRootIndex buildRootIndex;
        private final BuildTargetIndex buildTargetIndex;
        @NotNull
        private final HashMap<BuildTarget<?>, Set<BuildTarget<?>>> cache;

        public ModulesBasedFileFilter(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            this.context = context;
            this.chunkTargets = chunk.getTargets();
            this.buildRootIndex = this.context.getProjectDescriptor().getBuildRootIndex();
            this.buildTargetIndex = this.context.getProjectDescriptor().getBuildTargetIndex();
            this.cache = new HashMap();
        }

        public boolean accept(@NotNull File file) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            JavaSourceRootDescriptor javaSourceRootDescriptor = this.buildRootIndex.findJavaRootDescriptor(this.context, file);
            if (javaSourceRootDescriptor == null) {
                return true;
            }
            JavaSourceRootDescriptor rd = javaSourceRootDescriptor;
            ModuleBuildTarget moduleBuildTarget = rd.target;
            Intrinsics.checkNotNullExpressionValue((Object)moduleBuildTarget, (String)"rd.target");
            ModuleBuildTarget target = moduleBuildTarget;
            if (this.chunkTargets.contains(target)) {
                return true;
            }
            Map $this$getOrPut$iv = this.cache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target);
            if (value$iv == null) {
                boolean bl = false;
                BuildTargetIndex buildTargetIndex = this.buildTargetIndex;
                Intrinsics.checkNotNullExpressionValue((Object)buildTargetIndex, (String)"buildTargetIndex");
                Set<BuildTarget<?>> answer$iv = this.myGetDependenciesRecursively(buildTargetIndex, (BuildTarget)target, this.context);
                $this$getOrPut$iv.put(target, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Set targetOfFileWithDependencies = (Set)object;
            return ContainerUtil.intersects((Collection)targetOfFileWithDependencies, (Collection)this.chunkTargets);
        }

        private final Set<BuildTarget<?>> myGetDependenciesRecursively(BuildTargetIndex $this$myGetDependenciesRecursively, BuildTarget<?> target, CompileContext context) {
            LinkedHashSet result = new LinkedHashSet();
            for (BuildTarget dep : $this$myGetDependenciesRecursively.getDependencies(target, context)) {
                Intrinsics.checkNotNullExpressionValue((Object)dep, (String)"dep");
                ModulesBasedFileFilter.myGetDependenciesRecursively$collectDependenciesRecursively($this$myGetDependenciesRecursively, context, dep, result);
            }
            return result;
        }

        public boolean belongsToCurrentTargetChunk(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            JavaSourceRootDescriptor rd = this.buildRootIndex.findJavaRootDescriptor(this.context, file);
            return rd != null && this.chunkTargets.contains(rd.target);
        }

        private static final void myGetDependenciesRecursively$collectDependenciesRecursively(BuildTargetIndex $this$myGetDependenciesRecursively_u24collectDependenciesRecursively, CompileContext $context, BuildTarget<?> target, LinkedHashSet<? super BuildTarget<?>> result) {
            if (result.add(target)) {
                for (BuildTarget dep : $this$myGetDependenciesRecursively_u24collectDependenciesRecursively.getDependencies(target, $context)) {
                    Intrinsics.checkNotNullExpressionValue((Object)dep, (String)"dep");
                    ModulesBasedFileFilter.myGetDependenciesRecursively$collectDependenciesRecursively($this$myGetDependenciesRecursively_u24collectDependenciesRecursively, $context, dep, result);
                }
            }
        }
    }
}

