/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.extensions;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.BodyResolver;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisHandlerExtension;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J$\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001f0#H\u0002J*\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001f0#H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/extensions/PartialAnalysisHandlerExtension;", "Lorg/jetbrains/kotlin/resolve/jvm/extensions/AnalysisHandlerExtension;", "<init>", "()V", "analyzePartially", "", "getAnalyzePartially", "()Z", "analyzeDefaultParameterValues", "getAnalyzeDefaultParameterValues", "doAnalysis", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "projectContext", "Lorg/jetbrains/kotlin/context/ProjectContext;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "componentProvider", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "containingScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getContainingScope", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "doForEachDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "f", "Lkotlin/Function1;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nPartialAnalysisHandlerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialAnalysisHandlerExtension.kt\norg/jetbrains/kotlin/resolve/jvm/extensions/PartialAnalysisHandlerExtension\n+ 2 Dsl.kt\norg/jetbrains/kotlin/container/DslKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n37#2:147\n37#2:148\n37#2:149\n37#2:150\n1863#3,2:151\n1863#3,2:153\n*S KotlinDebug\n*F\n+ 1 PartialAnalysisHandlerExtension.kt\norg/jetbrains/kotlin/resolve/jvm/extensions/PartialAnalysisHandlerExtension\n*L\n54#1:147\n55#1:148\n56#1:149\n57#1:150\n135#1:151,2\n141#1:153,2\n*E\n"})
public class PartialAnalysisHandlerExtension
implements AnalysisHandlerExtension {
    public boolean getAnalyzePartially() {
        return true;
    }

    public boolean getAnalyzeDefaultParameterValues() {
        return false;
    }

    @Nullable
    public AnalysisResult doAnalysis(@NotNull Project project, @NotNull ModuleDescriptor module, @NotNull ProjectContext projectContext, @NotNull Collection<? extends KtFile> files, @NotNull BindingTrace bindingTrace, @NotNull ComponentProvider componentProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)projectContext, (String)"projectContext");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkNotNullParameter((Object)componentProvider, (String)"componentProvider");
        if (!this.getAnalyzePartially()) {
            return null;
        }
        ComponentProvider $this$get$iv = componentProvider;
        boolean $i$f$get = false;
        ResolveSession resolveSession = (ResolveSession)DslKt.getService((ComponentProvider)$this$get$iv, ResolveSession.class);
        ComponentProvider $this$get$iv2 = componentProvider;
        boolean $i$f$get2 = false;
        BodyResolver bodyResolver = (BodyResolver)DslKt.getService((ComponentProvider)$this$get$iv2, BodyResolver.class);
        ComponentProvider $this$get$iv3 = componentProvider;
        boolean $i$f$get3 = false;
        DeclarationScopeProvider declarationScopeProvider = (DeclarationScopeProvider)DslKt.getService((ComponentProvider)$this$get$iv3, DeclarationScopeProvider.class);
        ComponentProvider $this$get$iv4 = componentProvider;
        boolean $i$f$get4 = false;
        LazyTopDownAnalyzer topDownAnalyzer = (LazyTopDownAnalyzer)DslKt.getService((ComponentProvider)$this$get$iv4, LazyTopDownAnalyzer.class);
        TopDownAnalysisContext topDownAnalysisContext = new TopDownAnalysisContext(TopDownAnalysisMode.TopLevelDeclarations, DataFlowInfo.Companion.getEMPTY(), declarationScopeProvider);
        for (KtFile ktFile : files) {
            ForceResolveUtil.forceResolveAllContents((Annotations)resolveSession.getFileAnnotations(ktFile));
            topDownAnalyzer.resolveImportsInFile(ktFile);
        }
        this.doForEachDeclaration(files, (Function1<? super KtDeclaration, Unit>)((Function1)arg_0 -> PartialAnalysisHandlerExtension.doAnalysis$lambda$0(resolveSession, bodyResolver, topDownAnalysisContext, this, bindingTrace, arg_0)));
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        return AnalysisResult.Companion.success(bindingContext, module, true);
    }

    private final LexicalScope getContainingScope(DeclarationDescriptor $this$containingScope) {
        DeclarationDescriptor declarationDescriptor = $this$containingScope.getContainingDeclaration();
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        DeclarationDescriptor declarationDescriptor2 = containingDescriptor;
        return declarationDescriptor2 instanceof ClassDescriptorWithResolutionScopes ? ((ClassDescriptorWithResolutionScopes)containingDescriptor).getScopeForInitializerResolution() : (declarationDescriptor2 instanceof PackageFragmentDescriptor ? (LexicalScope)new LexicalScope.Base((HierarchicalScope)ScopeUtilsKt.memberScopeAsImportingScope$default((MemberScope)((PackageFragmentDescriptor)containingDescriptor).getMemberScope(), null, (int)1, null), $this$containingScope) : null);
    }

    private final void doForEachDeclaration(KtDeclaration declaration, Function1<? super KtDeclaration, Unit> f) {
        if (!(declaration instanceof KtAnonymousInitializer)) {
            f.invoke((Object)declaration);
        }
        if (declaration instanceof KtClassOrObject) {
            KtPrimaryConstructor primaryConstructor = ((KtClassOrObject)declaration).getPrimaryConstructor();
            if (primaryConstructor != null) {
                f.invoke((Object)primaryConstructor);
            }
            Iterable $this$forEach$iv = ((KtClassOrObject)declaration).getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl = false;
                this.doForEachDeclaration(it, f);
            }
        }
    }

    private final void doForEachDeclaration(Collection<? extends KtFile> files, Function1<? super KtDeclaration, Unit> f) {
        for (KtFile ktFile : files) {
            Iterable $this$forEach$iv = ktFile.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl = false;
                this.doForEachDeclaration(it, f);
            }
        }
    }

    private static final Unit doAnalysis$lambda$0(ResolveSession $resolveSession, BodyResolver $bodyResolver, TopDownAnalysisContext $topDownAnalysisContext, PartialAnalysisHandlerExtension this$0, BindingTrace $bindingTrace, KtDeclaration declaration) {
        DeclarationDescriptor descriptor;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        DeclarationDescriptor declarationDescriptor = $resolveSession.resolveToDescriptor(declaration);
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"resolveToDescriptor(...)");
        DeclarationDescriptor declarationDescriptor2 = descriptor = declarationDescriptor;
        if (declarationDescriptor2 instanceof ClassDescriptor) {
            ForceResolveUtil.forceResolveAllContents((Object)descriptor);
            ForceResolveUtil.forceResolveAllContents(((ClassDescriptor)descriptor).getTypeConstructor().getSupertypes());
            if (declaration instanceof KtClassOrObject && descriptor instanceof ClassDescriptorWithResolutionScopes) {
                $bodyResolver.resolveSuperTypeEntryList(DataFlowInfo.Companion.getEMPTY(), (KtClassOrObject)declaration, (ClassDescriptor)descriptor, (ConstructorDescriptor)((ClassDescriptorWithResolutionScopes)descriptor).getUnsubstitutedPrimaryConstructor(), ((ClassDescriptorWithResolutionScopes)descriptor).getScopeForConstructorHeaderResolution(), ((ClassDescriptorWithResolutionScopes)descriptor).getScopeForMemberDeclarationResolution(), $resolveSession.getInferenceSession());
            }
        } else if (declarationDescriptor2 instanceof PropertyDescriptor) {
            if (declaration instanceof KtProperty) {
                $bodyResolver.resolveProperty((BodiesResolveContext)$topDownAnalysisContext, (KtProperty)declaration, (PropertyDescriptor)descriptor);
            }
        } else if (declarationDescriptor2 instanceof FunctionDescriptor) {
            if (declaration instanceof KtPrimaryConstructor && (this$0.getAnalyzeDefaultParameterValues() || DescriptorUtilsKt.isAnnotationConstructor(descriptor))) {
                LexicalScope containingScope = this$0.getContainingScope(descriptor);
                if (containingScope != null) {
                    $bodyResolver.resolveConstructorParameterDefaultValues($topDownAnalysisContext.getOuterDataFlowInfo(), $bindingTrace, (KtPrimaryConstructor)declaration, (ConstructorDescriptor)descriptor, containingScope, $resolveSession.getInferenceSession());
                }
            } else if (declaration instanceof KtFunction && !((KtFunction)declaration).hasDeclaredReturnType() && !((KtFunction)declaration).hasBlockBody()) {
                ForceResolveUtil.forceResolveAllContents((Object)descriptor);
            }
        }
        return Unit.INSTANCE;
    }
}

