/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/SuspendInFunInterfaceChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class SuspendInFunInterfaceChecker
implements DeclarationChecker {
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(declaration instanceof KtClass)) {
            return;
        }
        if (!(descriptor instanceof ClassDescriptor) || !((ClassDescriptor)descriptor).isFun()) {
            return;
        }
        PsiElement psiElement = ((KtClass)declaration).getFunKeyword();
        if (psiElement == null) {
            return;
        }
        PsiElement funKeyword = psiElement;
        FunctionDescriptor functionDescriptor = SamConversionResolverImplKt.getSingleAbstractMethodOrNull((ClassDescriptor)descriptor);
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor abstractMember = functionDescriptor;
        if (!abstractMember.isSuspend()) {
            return;
        }
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.SuspendFunctionsInFunInterfaces)) {
            return;
        }
        SourceElement sourceElement = abstractMember.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement psiElement2 = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        KtNamedFunction ktFunction = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
        KtNamedFunction ktNamedFunction = ktFunction;
        if (ktNamedFunction == null || (ktNamedFunction = ktNamedFunction.getModifierList()) == null || (ktNamedFunction = ktNamedFunction.getModifier(KtTokens.SUSPEND_KEYWORD)) == null) {
            ktNamedFunction = funKeyword;
        }
        KtNamedFunction reportOn = ktNamedFunction;
        context.getTrace().report((Diagnostic)Errors.FUN_INTERFACE_WITH_SUSPEND_FUNCTION.on((PsiElement)reportOn));
    }
}

