/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerOutputParser;", "", "<init>", "()V", "parseCompilerMessagesFromReader", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reader", "Ljava/io/Reader;", "collector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "CompilerOutputSAXHandler", "kotlin-compiler-runner-unshaded"})
public final class CompilerOutputParser {
    @NotNull
    public static final CompilerOutputParser INSTANCE = new CompilerOutputParser();

    private CompilerOutputParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseCompilerMessagesFromReader(@NotNull MessageCollector messageCollector, @NotNull Reader reader, @NotNull OutputItemsCollector collector) {
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        StringBuilder stringBuilder = new StringBuilder();
        Reader wrappingReader2 = new Reader(reader, stringBuilder){
            final /* synthetic */ Reader $reader;
            final /* synthetic */ StringBuilder $stringBuilder;
            {
                this.$reader = $reader;
                this.$stringBuilder = $stringBuilder;
            }

            public int read(char[] cbuf, int off, int len) throws IOException {
                Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
                int read2 = this.$reader.read(cbuf, off, len);
                StringBuilder stringBuilder = this.$stringBuilder;
                int n = off + len;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(cbuf, off, n - off), (String)"append(...)");
                return read2;
            }

            public void close() throws IOException {
            }
        };
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(wrappingReader2), (DefaultHandler)new CompilerOutputSAXHandler(messageCollector, collector));
        }
        catch (Throwable e) {
            try {
                TextStreamsKt.readText((Reader)wrappingReader2);
            }
            catch (IOException ioException) {
                MessageCollectorUtil.reportException(messageCollector, ioException);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String message = string;
            MessageCollectorUtil.reportException(messageCollector, new IllegalStateException(message, e));
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, message, null, 4, null);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                MessageCollectorUtil.reportException(messageCollector, e);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0007\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\"\u0010\u001f\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler;", "Lorg/xml/sax/helpers/DefaultHandler;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "collector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;)V", "message", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "tags", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "path", "line", "", "column", "startElement", "", "uri", "localName", "qName", "attributes", "Lorg/xml/sax/Attributes;", "characters", "ch", "", "start", "length", "endElement", "reportToCollector", "text", "Companion", "kotlin-compiler-runner-unshaded"})
    @SourceDebugExtension(value={"SMAP\nCompilerOutputParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerOutputParser.kt\norg/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,173:1\n106#2:174\n78#2,22:175\n*S KotlinDebug\n*F\n+ 1 CompilerOutputParser.kt\norg/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler\n*L\n111#1:174\n111#1:175,22\n*E\n"})
    private static final class CompilerOutputSAXHandler
    extends DefaultHandler {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MessageCollector messageCollector;
        @NotNull
        private final OutputItemsCollector collector;
        @NotNull
        private final StringBuilder message;
        @NotNull
        private final ArrayList<String> tags;
        @Nullable
        private String path;
        private int line;
        private int column;
        @NotNull
        private static final Map<String, CompilerMessageSeverity> CATEGORIES;

        public CompilerOutputSAXHandler(@NotNull MessageCollector messageCollector, @NotNull OutputItemsCollector collector) {
            Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
            Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
            this.messageCollector = messageCollector;
            this.collector = collector;
            this.message = new StringBuilder();
            this.tags = new ArrayList();
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            this.tags.add(qName);
            this.message.setLength(0);
            this.path = attributes.getValue("path");
            this.line = CompilerOutputSAXHandler.Companion.safeParseInt(attributes.getValue("line"), -1);
            this.column = CompilerOutputSAXHandler.Companion.safeParseInt(attributes.getValue("column"), -1);
        }

        @Override
        public void characters(@Nullable char[] ch, int start, int length) throws SAXException {
            if (this.tags.size() == 1) {
                String message;
                Intrinsics.checkNotNull((Object)ch);
                String $this$trim$iv = message = new String(ch, start, length);
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) {
                    MessageCollector.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, "Unhandled compiler output: " + message, null, 4, null);
                }
            } else {
                this.message.append(ch, start, length);
            }
        }

        @Override
        public void endElement(@Nullable String uri, @NotNull String localName, @NotNull String qName) throws SAXException {
            Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
            Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
            if (this.tags.size() == 1) {
                return;
            }
            String string = qName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String qNameLowerCase = string;
            CompilerMessageSeverity category = CATEGORIES.get(qNameLowerCase);
            if (category == null) {
                MessageCollector.report$default(this.messageCollector, CompilerMessageSeverity.ERROR, "Unknown compiler message tag: " + qName, null, 4, null);
                category = CompilerMessageSeverity.INFO;
            }
            String string2 = this.message.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String text = string2;
            if (category == CompilerMessageSeverity.OUTPUT) {
                this.reportToCollector(text);
            } else {
                this.messageCollector.report(category, text, CompilerMessageLocation.Companion.create(this.path, this.line, this.column, null));
            }
            this.tags.remove(this.tags.size() - 1);
        }

        private final void reportToCollector(String text) {
            OutputMessageUtil.Output output = OutputMessageUtil.parseOutputMessage(text);
            if (output != null) {
                this.collector.add(output.sourceFiles, output.outputFile);
            }
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"error", (Object)((Object)CompilerMessageSeverity.ERROR)), TuplesKt.to((Object)"warning", (Object)((Object)CompilerMessageSeverity.WARNING)), TuplesKt.to((Object)"logging", (Object)((Object)CompilerMessageSeverity.LOGGING)), TuplesKt.to((Object)"output", (Object)((Object)CompilerMessageSeverity.OUTPUT)), TuplesKt.to((Object)"exception", (Object)((Object)CompilerMessageSeverity.EXCEPTION)), TuplesKt.to((Object)"info", (Object)((Object)CompilerMessageSeverity.INFO)), TuplesKt.to((Object)"messages", (Object)((Object)CompilerMessageSeverity.INFO))};
            CATEGORIES = MapsKt.mapOf((Pair[])pairArray);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\tH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler$Companion;", "", "<init>", "()V", "CATEGORIES", "", "", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "safeParseInt", "", "value", "defaultValue", "kotlin-compiler-runner-unshaded"})
        @SourceDebugExtension(value={"SMAP\nCompilerOutputParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerOutputParser.kt\norg/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,173:1\n106#2:174\n78#2,22:175\n*S KotlinDebug\n*F\n+ 1 CompilerOutputParser.kt\norg/jetbrains/kotlin/compilerRunner/CompilerOutputParser$CompilerOutputSAXHandler$Companion\n*L\n164#1:174\n164#1:175,22\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final int safeParseInt(String value2, int defaultValue) {
                if (value2 == null) {
                    return defaultValue;
                }
                try {
                    String $this$trim$iv = value2;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    return Integer.parseInt(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                }
                catch (NumberFormatException e) {
                    return defaultValue;
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

