/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheVersion;
import org.jetbrains.kotlin.jps.incremental.CacheVersionManager;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributes;
import org.jetbrains.kotlin.jps.incremental.LookupsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0018\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesManager;", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributes;", "rootPath", "Ljava/nio/file/Path;", "expectedComponents", "", "", "<init>", "(Ljava/nio/file/Path;Ljava/util/Set;)V", "versionManager", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "actualComponentsFile", "kotlin.jvm.PlatformType", "expected", "getExpected", "()Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributes;", "loadActual", "writeVersion", "", "values", "isCompatible", "", "actual", "versionManagerForTesting", "getVersionManagerForTesting", "()Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nCompositeLookupsCacheAttributes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeLookupsCacheAttributes.kt\norg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class CompositeLookupsCacheAttributesManager
implements CacheAttributesManager<CompositeLookupsCacheAttributes> {
    @NotNull
    private final CacheVersionManager versionManager;
    private final Path actualComponentsFile;
    @Nullable
    private final CompositeLookupsCacheAttributes expected;

    public CompositeLookupsCacheAttributesManager(@NotNull Path rootPath, @NotNull Set<String> expectedComponents) {
        CompositeLookupsCacheAttributes compositeLookupsCacheAttributes;
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter(expectedComponents, (String)"expectedComponents");
        this.versionManager = LookupsKt.lookupsCacheVersionManager(rootPath, !((Collection)expectedComponents).isEmpty());
        this.actualComponentsFile = rootPath.resolve("components.txt");
        if (expectedComponents.isEmpty()) {
            compositeLookupsCacheAttributes = null;
        } else {
            CacheVersion cacheVersion = this.versionManager.getExpected();
            Intrinsics.checkNotNull((Object)cacheVersion);
            compositeLookupsCacheAttributes = new CompositeLookupsCacheAttributes(cacheVersion.getIntValue(), expectedComponents);
        }
        this.expected = compositeLookupsCacheAttributes;
    }

    @Override
    @Nullable
    public CompositeLookupsCacheAttributes getExpected() {
        return this.expected;
    }

    @Override
    @Nullable
    public CompositeLookupsCacheAttributes loadActual() {
        Set set;
        CacheVersion cacheVersion = this.versionManager.loadActual();
        if (cacheVersion == null) {
            return null;
        }
        CacheVersion version = cacheVersion;
        if (Files.notExists(this.actualComponentsFile, new LinkOption[0])) {
            return null;
        }
        try {
            List<String> list = Files.readAllLines(this.actualComponentsFile);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            set = CollectionsKt.toSet((Iterable)list);
        }
        catch (IOException e) {
            return null;
        }
        Set components = set;
        return new CompositeLookupsCacheAttributes(version.getIntValue(), components);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeVersion(@Nullable CompositeLookupsCacheAttributes values) {
        if (values == null) {
            this.versionManager.writeVersion(null);
            Files.deleteIfExists(this.actualComponentsFile);
        } else {
            this.versionManager.writeVersion(new CacheVersion(values.getVersion()));
            Files.createDirectories(this.actualComponentsFile.getParent(), new FileAttribute[0]);
            OutputStream outputStream = Files.newOutputStream(this.actualComponentsFile, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            Object object = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object = null;
            try {
                BufferedWriter it = (BufferedWriter)closeable;
                boolean bl = false;
                writer = it.append(CollectionsKt.joinToString$default((Iterable)values.getComponents(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
    }

    @Override
    public boolean isCompatible(@NotNull CompositeLookupsCacheAttributes actual, @NotNull CompositeLookupsCacheAttributes expected) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return actual.getVersion() == expected.getVersion() && actual.getComponents().containsAll((Collection)expected.getComponents());
    }

    @TestOnly
    @NotNull
    public final CacheVersionManager getVersionManagerForTesting() {
        return this.versionManager;
    }
}

