/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.model;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.Freezable;
import org.jetbrains.kotlin.cli.common.arguments.FreezableKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinModuleKind;
import org.jetbrains.kotlin.jps.model.JpsKotlinCompilerSettings;
import org.jetbrains.kotlin.jps.model.JpsKotlinFacetModuleExtension;
import org.jetbrains.kotlin.jps.model.ProjectSettingsKt;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011*\u00020\u00022\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0011H\u0002\u001a\u001e\u0010*\u001a\u0002H+\"\n\b\u0000\u0010+\u0018\u0001*\u00020#*\u00020\u0002H\u0082\b\u00a2\u0006\u0002\u0010%\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\"\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\"\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u0018*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\"\u0015\u0010\u001e\u001a\u00020\u001f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u0015\u0010\"\u001a\u00020#*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"\u0015\u0010&\u001a\u00020'*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"kotlinFacet", "Lorg/jetbrains/kotlin/jps/model/JpsKotlinFacetModuleExtension;", "Lorg/jetbrains/jps/model/module/JpsModule;", "getKotlinFacet", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/jps/model/JpsKotlinFacetModuleExtension;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/platform/TargetPlatform;", "kotlinKind", "Lorg/jetbrains/kotlin/config/KotlinModuleKind;", "getKotlinKind", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/config/KotlinModuleKind;", "isTestModule", "", "(Lorg/jetbrains/jps/model/module/JpsModule;)Z", "sourceSetModules", "", "getSourceSetModules", "(Lorg/jetbrains/jps/model/module/JpsModule;)Ljava/util/List;", "expectedByModules", "getExpectedByModules", "findDependencies", "moduleNames", "", "productionOutputFilePath", "getProductionOutputFilePath", "(Lorg/jetbrains/jps/model/module/JpsModule;)Ljava/lang/String;", "testOutputFilePath", "getTestOutputFilePath", "kotlinCompilerSettings", "Lorg/jetbrains/kotlin/config/CompilerSettings;", "getKotlinCompilerSettings", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/config/CompilerSettings;", "kotlinCompilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "getKotlinCompilerArguments", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "k2JvmCompilerArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "getK2JvmCompilerArguments", "(Lorg/jetbrains/jps/model/module/JpsModule;)Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "getCompilerArguments", "T", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nModuleSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleSettings.kt\norg/jetbrains/kotlin/jps/model/ModuleSettingsKt\n*L\n1#1,115:1\n88#1,7:116\n88#1,7:123\n*S KotlinDebug\n*F\n+ 1 ModuleSettings.kt\norg/jetbrains/kotlin/jps/model/ModuleSettingsKt\n*L\n82#1:116,7\n85#1:123,7\n*E\n"})
public final class ModuleSettingsKt {
    @Nullable
    public static final JpsKotlinFacetModuleExtension getKotlinFacet(@NotNull JpsModule $this$kotlinFacet) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinFacet, (String)"<this>");
        return (JpsKotlinFacetModuleExtension)$this$kotlinFacet.getContainer().getChild((JpsElementChildRole)JpsKotlinFacetModuleExtension.Companion.getKIND());
    }

    @Nullable
    public static final TargetPlatform getPlatform(@NotNull JpsModule $this$platform) {
        Intrinsics.checkNotNullParameter((Object)$this$platform, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$platform);
        return object != null && (object = object.getSettings()) != null ? ((KotlinFacetSettings)object).getTargetPlatform() : null;
    }

    @NotNull
    public static final KotlinModuleKind getKotlinKind(@NotNull JpsModule $this$kotlinKind) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinKind, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$kotlinKind);
        if (object == null || (object = object.getSettings()) == null || (object = ((KotlinFacetSettings)object).getKind()) == null) {
            object = KotlinModuleKind.DEFAULT;
        }
        return object;
    }

    public static final boolean isTestModule(@NotNull JpsModule $this$isTestModule) {
        Intrinsics.checkNotNullParameter((Object)$this$isTestModule, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$isTestModule);
        return object != null && (object = object.getSettings()) != null ? ((KotlinFacetSettings)object).isTestModule() : false;
    }

    @NotNull
    public static final List<JpsModule> getSourceSetModules(@NotNull JpsModule $this$sourceSetModules) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceSetModules, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$sourceSetModules);
        return ModuleSettingsKt.findDependencies($this$sourceSetModules, object != null && (object = object.getSettings()) != null ? ((KotlinFacetSettings)object).getSourceSetNames() : null);
    }

    @NotNull
    public static final List<JpsModule> getExpectedByModules(@NotNull JpsModule $this$expectedByModules) {
        Intrinsics.checkNotNullParameter((Object)$this$expectedByModules, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$expectedByModules);
        return ModuleSettingsKt.findDependencies($this$expectedByModules, object != null && (object = object.getSettings()) != null ? ((KotlinFacetSettings)object).getImplementedModuleNames() : null);
    }

    private static final List<JpsModule> findDependencies(JpsModule $this$findDependencies, List<String> moduleNames) {
        if (moduleNames == null || moduleNames.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Set result = new LinkedHashSet();
        JpsJavaExtensionService.dependencies((JpsModule)$this$findDependencies).processModules(arg_0 -> ModuleSettingsKt.findDependencies$lambda$1(arg_0 -> ModuleSettingsKt.findDependencies$lambda$0(moduleNames, result, arg_0), arg_0));
        return CollectionsKt.toList((Iterable)result);
    }

    @Nullable
    public static final String getProductionOutputFilePath(@NotNull JpsModule $this$productionOutputFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$productionOutputFilePath, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$productionOutputFilePath);
        if (object == null || (object = object.getSettings()) == null) {
            return null;
        }
        Object facetSettings = object;
        if (((KotlinFacetSettings)facetSettings).getUseProjectSettings()) {
            return null;
        }
        return ((KotlinFacetSettings)facetSettings).getProductionOutputPath();
    }

    @Nullable
    public static final String getTestOutputFilePath(@NotNull JpsModule $this$testOutputFilePath) {
        Intrinsics.checkNotNullParameter((Object)$this$testOutputFilePath, (String)"<this>");
        Object object = ModuleSettingsKt.getKotlinFacet($this$testOutputFilePath);
        if (object == null || (object = object.getSettings()) == null) {
            return null;
        }
        Object facetSettings = object;
        if (((KotlinFacetSettings)facetSettings).getUseProjectSettings()) {
            return null;
        }
        return ((KotlinFacetSettings)facetSettings).getTestOutputPath();
    }

    @NotNull
    public static final CompilerSettings getKotlinCompilerSettings(@NotNull JpsModule $this$kotlinCompilerSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinCompilerSettings, (String)"<this>");
        JpsProject jpsProject = $this$kotlinCompilerSettings.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"getProject(...)");
        CompilerSettings defaultSettings = (CompilerSettings)FreezableKt.copyOf((Freezable)ProjectSettingsKt.getKotlinCompilerSettings(jpsProject));
        Object object = ModuleSettingsKt.getKotlinFacet($this$kotlinCompilerSettings);
        if (object == null || (object = object.getSettings()) == null) {
            return defaultSettings;
        }
        Object facetSettings = object;
        if (((KotlinFacetSettings)facetSettings).getUseProjectSettings()) {
            return defaultSettings;
        }
        CompilerSettings compilerSettings = ((KotlinFacetSettings)facetSettings).getCompilerSettings();
        if (compilerSettings == null) {
            compilerSettings = defaultSettings;
        }
        return compilerSettings;
    }

    @NotNull
    public static final CommonCompilerArguments getKotlinCompilerArguments(@NotNull JpsModule $this$kotlinCompilerArguments) {
        CommonCompilerArguments commonCompilerArguments;
        Intrinsics.checkNotNullParameter((Object)$this$kotlinCompilerArguments, (String)"<this>");
        JpsModule $this$getCompilerArguments$iv = $this$kotlinCompilerArguments;
        boolean $i$f$getCompilerArguments = false;
        JpsProject jpsProject = $this$getCompilerArguments$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"getProject(...)");
        CommonCompilerArguments projectSettings$iv = ProjectSettingsKt.getKotlinCompilerSettingsContainer(jpsProject).get$jps_plugin(CommonCompilerArguments.class);
        CommonCompilerArguments projectSettingsCopy$iv = (CommonCompilerArguments)FreezableKt.copyOf((Freezable)projectSettings$iv);
        Object object = ModuleSettingsKt.getKotlinFacet($this$getCompilerArguments$iv);
        if (object == null || (object = object.getSettings()) == null) {
            commonCompilerArguments = projectSettingsCopy$iv;
        } else {
            Object facetSettings$iv = object;
            if (((KotlinFacetSettings)facetSettings$iv).getUseProjectSettings()) {
                commonCompilerArguments = projectSettingsCopy$iv;
            } else {
                ((KotlinFacetSettings)facetSettings$iv).updateMergedArguments();
                CommonCompilerArguments commonCompilerArguments2 = ((KotlinFacetSettings)facetSettings$iv).getMergedCompilerArguments();
                if (!(commonCompilerArguments2 instanceof CommonCompilerArguments)) {
                    commonCompilerArguments2 = commonCompilerArguments = null;
                }
                if (commonCompilerArguments2 == null) {
                    commonCompilerArguments = projectSettingsCopy$iv;
                }
            }
        }
        return commonCompilerArguments;
    }

    @NotNull
    public static final K2JVMCompilerArguments getK2JvmCompilerArguments(@NotNull JpsModule $this$k2JvmCompilerArguments) {
        CommonCompilerArguments commonCompilerArguments;
        Intrinsics.checkNotNullParameter((Object)$this$k2JvmCompilerArguments, (String)"<this>");
        JpsModule $this$getCompilerArguments$iv = $this$k2JvmCompilerArguments;
        boolean $i$f$getCompilerArguments = false;
        JpsProject jpsProject = $this$getCompilerArguments$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"getProject(...)");
        K2JVMCompilerArguments projectSettings$iv = ProjectSettingsKt.getKotlinCompilerSettingsContainer(jpsProject).get$jps_plugin(K2JVMCompilerArguments.class);
        CommonCompilerArguments projectSettingsCopy$iv = (CommonCompilerArguments)FreezableKt.copyOf((Freezable)projectSettings$iv);
        Object object = ModuleSettingsKt.getKotlinFacet($this$getCompilerArguments$iv);
        if (object == null || (object = object.getSettings()) == null) {
            commonCompilerArguments = projectSettingsCopy$iv;
        } else {
            Object facetSettings$iv = object;
            if (((KotlinFacetSettings)facetSettings$iv).getUseProjectSettings()) {
                commonCompilerArguments = projectSettingsCopy$iv;
            } else {
                ((KotlinFacetSettings)facetSettings$iv).updateMergedArguments();
                CommonCompilerArguments commonCompilerArguments2 = ((KotlinFacetSettings)facetSettings$iv).getMergedCompilerArguments();
                if (!(commonCompilerArguments2 instanceof K2JVMCompilerArguments)) {
                    commonCompilerArguments2 = null;
                }
                if ((commonCompilerArguments = (CommonCompilerArguments)((K2JVMCompilerArguments)commonCompilerArguments2)) == null) {
                    commonCompilerArguments = projectSettingsCopy$iv;
                }
            }
        }
        return (K2JVMCompilerArguments)commonCompilerArguments;
    }

    private static final /* synthetic */ <T extends CommonCompilerArguments> T getCompilerArguments(JpsModule $this$getCompilerArguments) {
        boolean $i$f$getCompilerArguments = false;
        JpsProject jpsProject = $this$getCompilerArguments.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)jpsProject, (String)"getProject(...)");
        JpsKotlinCompilerSettings jpsKotlinCompilerSettings = ProjectSettingsKt.getKotlinCompilerSettingsContainer(jpsProject);
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        CommonCompilerArguments projectSettings = jpsKotlinCompilerSettings.get$jps_plugin(CommonCompilerArguments.class);
        CommonCompilerArguments projectSettingsCopy = (CommonCompilerArguments)FreezableKt.copyOf((Freezable)projectSettings);
        Object object = ModuleSettingsKt.getKotlinFacet($this$getCompilerArguments);
        if (object == null || (object = object.getSettings()) == null) {
            return (T)projectSettingsCopy;
        }
        Object facetSettings = object;
        if (((KotlinFacetSettings)facetSettings).getUseProjectSettings()) {
            return (T)projectSettingsCopy;
        }
        ((KotlinFacetSettings)facetSettings).updateMergedArguments();
        CommonCompilerArguments commonCompilerArguments = ((KotlinFacetSettings)facetSettings).getMergedCompilerArguments();
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)(commonCompilerArguments != null ? commonCompilerArguments : projectSettingsCopy);
    }

    private static final Unit findDependencies$lambda$0(List $moduleNames, Set $result, JpsModule it) {
        if ($moduleNames.contains(it.getName())) {
            Intrinsics.checkNotNull((Object)it);
            $result.add(it);
        }
        return Unit.INSTANCE;
    }

    private static final void findDependencies$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

