/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.multiplatform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaPropertyInitializerEvaluatorImpl;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationAsAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaArrayAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import org.jetbrains.kotlin.load.java.structure.JavaClassObjectAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaEnumValueAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaLiteralAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/multiplatform/JavaActualAnnotationArgumentExtractor;", "Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "<init>", "()V", "extractDefaultValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "convert", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotationArgument;", "convertTypeToKClassValue", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue;", "javaType", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJavaActualAnnotationArgumentExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaActualAnnotationArgumentExtractor.kt\norg/jetbrains/kotlin/resolve/jvm/multiplatform/JavaActualAnnotationArgumentExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1642#2,10:89\n1915#2:99\n1916#2:101\n1652#2:102\n1#3:100\n*S KotlinDebug\n*F\n+ 1 JavaActualAnnotationArgumentExtractor.kt\norg/jetbrains/kotlin/resolve/jvm/multiplatform/JavaActualAnnotationArgumentExtractor\n*L\n46#1:89,10\n46#1:99\n46#1:101\n46#1:102\n46#1:100\n*E\n"})
public final class JavaActualAnnotationArgumentExtractor
implements ExpectedActualDeclarationChecker.ActualAnnotationArgumentExtractor {
    @Nullable
    public ConstantValue<?> extractDefaultValue(@NotNull ValueParameterDescriptor parameter, @NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        SourceElement sourceElement = parameter.getSource();
        JavaSourceElement javaSourceElement = sourceElement instanceof JavaSourceElement ? (JavaSourceElement)sourceElement : null;
        JavaElement element = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
        Object object = element instanceof JavaMethod ? (JavaMethod)element : null;
        return object != null && (object = object.getAnnotationParameterDefaultValue()) != null ? this.convert((JavaAnnotationArgument)object, expectedType) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ConstantValue<?> convert(JavaAnnotationArgument $this$convert, KotlinType expectedType) {
        ConstantValue constantValue;
        JavaAnnotationArgument javaAnnotationArgument = $this$convert;
        if (javaAnnotationArgument instanceof JavaLiteralAnnotationArgument) {
            Object object = ((JavaLiteralAnnotationArgument)$this$convert).getValue();
            if (object != null) {
                Object it = object;
                boolean bl = false;
                constantValue = JavaPropertyInitializerEvaluatorImpl.INSTANCE.convertLiteralValue$frontend_java(it, expectedType);
            } else {
                constantValue = null;
            }
        } else if (javaAnnotationArgument instanceof JavaEnumValueAnnotationArgument) {
            EnumValue enumValue;
            ClassId classId = ((JavaEnumValueAnnotationArgument)$this$convert).getEnumClassId();
            if (classId != null) {
                ClassId enumClassId = classId;
                boolean bl = false;
                Name name = ((JavaEnumValueAnnotationArgument)$this$convert).getEntryName();
                if (name != null) {
                    Name entryName = name;
                    boolean bl2 = false;
                    enumValue = new EnumValue(enumClassId, entryName);
                } else {
                    enumValue = null;
                }
            } else {
                enumValue = null;
            }
            constantValue = enumValue;
        } else if (javaAnnotationArgument instanceof JavaArrayAnnotationArgument) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            KotlinType kotlinType = TypeUtilsKt.getBuiltIns(expectedType).getArrayElementType(expectedType);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getArrayElementType(...)");
            KotlinType elementType = kotlinType;
            Iterable iterable = ((JavaArrayAnnotationArgument)$this$convert).getElements();
            ConstantValueFactory constantValueFactory = ConstantValueFactory.INSTANCE;
            boolean $i$f$mapNotNull = false;
            void bl = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ConstantValue<?> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                JavaAnnotationArgument it = (JavaAnnotationArgument)element$iv$iv;
                boolean bl4 = false;
                if (this.convert(it, elementType) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            constantValue = constantValueFactory.createArrayValue((List)destination$iv$iv, expectedType);
        } else {
            constantValue = javaAnnotationArgument instanceof JavaAnnotationAsAnnotationArgument ? null : (javaAnnotationArgument instanceof JavaClassObjectAnnotationArgument ? (ConstantValue)this.convertTypeToKClassValue(((JavaClassObjectAnnotationArgument)$this$convert).getReferencedType()) : null);
        }
        return constantValue;
    }

    private final KClassValue convertTypeToKClassValue(JavaType javaType) {
        KClassValue kClassValue;
        JavaType type = javaType;
        int arrayDimensions = 0;
        while (type instanceof JavaArrayType) {
            type = ((JavaArrayType)type).getComponentType();
            ++arrayDimensions;
        }
        JavaType javaType2 = type;
        if (javaType2 instanceof JavaPrimitiveType) {
            PrimitiveType primitiveType = ((JavaPrimitiveType)type).getType();
            if (primitiveType == null) {
                return new KClassValue(ClassId.Companion.topLevel(StandardNames.FqNames.unit.toSafe()), 0);
            }
            PrimitiveType primitiveType2 = primitiveType;
            kClassValue = arrayDimensions > 0 ? new KClassValue(ClassId.Companion.topLevel(primitiveType2.getArrayTypeFqName()), arrayDimensions - 1) : new KClassValue(ClassId.Companion.topLevel(primitiveType2.getTypeFqName()), arrayDimensions);
        } else if (javaType2 instanceof JavaClassifierType) {
            FqName fqName = new FqName(((JavaClassifierType)type).getClassifierQualifiedName());
            ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(fqName);
            if (classId == null) {
                classId = ClassId.Companion.topLevel(fqName);
            }
            ClassId classId2 = classId;
            kClassValue = new KClassValue(classId2, arrayDimensions);
        } else {
            kClassValue = null;
        }
        return kClassValue;
    }
}

