/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import org.jetbrains.kotlin.com.google.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.internal.InjectorImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InternalContext;
import org.jetbrains.kotlin.com.google.inject.internal.InternalFactory;

final class ProviderToInternalFactoryAdapter<T>
implements Provider<T> {
    private final InjectorImpl injector;
    private final InternalFactory<? extends T> internalFactory;

    public ProviderToInternalFactoryAdapter(InjectorImpl injector, InternalFactory<? extends T> internalFactory) {
        this.injector = injector;
        this.internalFactory = internalFactory;
    }

    @Override
    public T get() {
        try (InternalContext context = this.injector.enterContext();){
            T t;
            T t2 = t = this.internalFactory.get(context, context.getDependency(), true);
            return t2;
        }
    }

    InjectorImpl getInjector() {
        return this.injector;
    }

    public String toString() {
        return this.internalFactory.toString();
    }
}

