/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.inject;

import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.Injector;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.org.eclipse.sisu.Hidden;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.BindingPublisher;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Logs;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Sources;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.TypeArguments;

final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type) {
        Key<T> implicitKey = TypeArguments.implicitKey(type.getRawType());
        for (BindingPublisher p : this.publishers) {
            Binding<?> binding;
            Injector injector = p.adapt(Injector.class);
            if (null == injector || null == (binding = injector.getBindings().get(implicitKey))) continue;
            Logs.trace("Using implicit binding: {} from: <>", binding, injector);
            return binding;
        }
        Key<T> justInTimeKey = Key.get(type);
        for (BindingPublisher p : this.publishers) {
            Injector injector = p.adapt(Injector.class);
            if (null == injector) continue;
            try {
                Binding<T> binding = injector.getBinding(justInTimeKey);
                if (null != Sources.getAnnotation(binding, Hidden.class)) continue;
                Logs.trace("Using just-in-time binding: {} from: <>", binding, injector);
                return binding;
            }
            catch (RuntimeException e) {
                Logs.debug("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
            catch (LinkageError e) {
                Logs.debug("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
        }
        return null;
    }
}

