/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import javax.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.spi.TypeEncounter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Configuration;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Requirement;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanManager;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanProperty;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.PropertyBinder;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.PropertyBinding;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.OptionalPropertyBinding;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusConfigurations;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusRequirements;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.ProvidedPropertyBinding;

final class PlexusPropertyBinder
implements PropertyBinder {
    private static final boolean OPTIONAL_SUPPORTED;
    private final BeanManager manager;
    private final PlexusBeanMetadata metadata;
    private final PlexusConfigurations configurations;
    private final PlexusRequirements requirements;

    PlexusPropertyBinder(BeanManager manager, TypeEncounter<?> encounter, PlexusBeanMetadata metadata) {
        this.manager = manager;
        this.metadata = metadata;
        this.configurations = new PlexusConfigurations(encounter);
        this.requirements = new PlexusRequirements(encounter);
    }

    @Override
    public <T> PropertyBinding bindProperty(BeanProperty<T> property) {
        if (this.metadata.isEmpty()) {
            return PropertyBinder.LAST_BINDING;
        }
        Configuration configuration = this.metadata.getConfiguration(property);
        if (null != configuration) {
            Provider<T> valueProvider = this.configurations.lookup(configuration, property);
            return new ProvidedPropertyBinding<T>(property, valueProvider);
        }
        Requirement requirement = this.metadata.getRequirement(property);
        if (null != requirement) {
            PropertyBinding managedBinding;
            if (null != this.manager && null != (managedBinding = this.manager.manage(property))) {
                return managedBinding;
            }
            Provider<T> roleProvider = this.requirements.lookup(requirement, property);
            if (OPTIONAL_SUPPORTED && requirement.optional()) {
                return new OptionalPropertyBinding<T>(property, roleProvider);
            }
            return new ProvidedPropertyBinding<T>(property, roleProvider);
        }
        return null;
    }

    static {
        boolean optionalSupported = true;
        try {
            Requirement.class.getDeclaredMethod("optional", new Class[0]);
        }
        catch (Exception e) {
            optionalSupported = false;
        }
        catch (LinkageError e) {
            optionalSupported = false;
        }
        OPTIONAL_SUPPORTED = optionalSupported;
    }
}

