/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.project.model;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.project.model.KotlinModule;
import org.jetbrains.kotlin.project.model.KotlinModuleVariant;
import org.jetbrains.kotlin.project.model.VariantResolution;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\u0006\r\u000e\u000f\u0010\u0011\u0012B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0001\u0005\u0013\u0014\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/project/model/VariantResolution;", "", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KotlinModule;", "(Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;Lorg/jetbrains/kotlin/project/model/KotlinModule;)V", "getDependencyModule", "()Lorg/jetbrains/kotlin/project/model/KotlinModule;", "getRequestingVariant", "()Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;", "toString", "", "AmbiguousVariants", "Companion", "NoVariantMatch", "NotRequested", "Unknown", "VariantMatch", "Lorg/jetbrains/kotlin/project/model/VariantResolution$VariantMatch;", "Lorg/jetbrains/kotlin/project/model/VariantResolution$Unknown;", "Lorg/jetbrains/kotlin/project/model/VariantResolution$NotRequested;", "Lorg/jetbrains/kotlin/project/model/VariantResolution$NoVariantMatch;", "Lorg/jetbrains/kotlin/project/model/VariantResolution$AmbiguousVariants;", "kotlin-project-model"})
public abstract class VariantResolution {
    @NotNull
    private final KotlinModuleVariant requestingVariant;
    @NotNull
    private final KotlinModule dependencyModule;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        String string;
        VariantResolution variantResolution = this;
        if (variantResolution instanceof VariantMatch) {
            string = "match: " + ((VariantMatch)this).getChosenVariant().getFragmentName();
        } else if (variantResolution instanceof Unknown) {
            string = "unknown";
        } else if (variantResolution instanceof NotRequested) {
            string = "not requested";
        } else if (variantResolution instanceof NoVariantMatch) {
            string = "no match";
        } else if (variantResolution instanceof AmbiguousVariants) {
            string = "ambiguity: " + CollectionsKt.joinToString$default(((AmbiguousVariants)this).getMatchingVariants(), null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final KotlinModuleVariant getRequestingVariant() {
        return this.requestingVariant;
    }

    @NotNull
    public final KotlinModule getDependencyModule() {
        return this.dependencyModule;
    }

    private VariantResolution(KotlinModuleVariant requestingVariant, KotlinModule dependencyModule) {
        this.requestingVariant = requestingVariant;
        this.dependencyModule = dependencyModule;
    }

    public /* synthetic */ VariantResolution(KotlinModuleVariant requestingVariant, KotlinModule dependencyModule, DefaultConstructorMarker $constructor_marker) {
        this(requestingVariant, dependencyModule);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/project/model/VariantResolution$VariantMatch;", "Lorg/jetbrains/kotlin/project/model/VariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KotlinModule;", "chosenVariant", "(Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;Lorg/jetbrains/kotlin/project/model/KotlinModule;Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;)V", "getChosenVariant", "()Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;", "kotlin-project-model"})
    public static final class VariantMatch
    extends VariantResolution {
        @NotNull
        private final KotlinModuleVariant chosenVariant;

        @NotNull
        public final KotlinModuleVariant getChosenVariant() {
            return this.chosenVariant;
        }

        public VariantMatch(@NotNull KotlinModuleVariant requestingVariant, @NotNull KotlinModule dependencyModule, @NotNull KotlinModuleVariant chosenVariant) {
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            Intrinsics.checkNotNullParameter((Object)chosenVariant, (String)"chosenVariant");
            super(requestingVariant, dependencyModule, null);
            this.chosenVariant = chosenVariant;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/project/model/VariantResolution$Unknown;", "Lorg/jetbrains/kotlin/project/model/VariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KotlinModule;", "(Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;Lorg/jetbrains/kotlin/project/model/KotlinModule;)V", "kotlin-project-model"})
    public static final class Unknown
    extends VariantResolution {
        public Unknown(@NotNull KotlinModuleVariant requestingVariant, @NotNull KotlinModule dependencyModule) {
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            super(requestingVariant, dependencyModule, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/project/model/VariantResolution$NotRequested;", "Lorg/jetbrains/kotlin/project/model/VariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KotlinModule;", "(Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;Lorg/jetbrains/kotlin/project/model/KotlinModule;)V", "kotlin-project-model"})
    public static final class NotRequested
    extends VariantResolution {
        public NotRequested(@NotNull KotlinModuleVariant requestingVariant, @NotNull KotlinModule dependencyModule) {
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            super(requestingVariant, dependencyModule, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/project/model/VariantResolution$NoVariantMatch;", "Lorg/jetbrains/kotlin/project/model/VariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KotlinModule;", "(Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;Lorg/jetbrains/kotlin/project/model/KotlinModule;)V", "kotlin-project-model"})
    public static final class NoVariantMatch
    extends VariantResolution {
        public NoVariantMatch(@NotNull KotlinModuleVariant requestingVariant, @NotNull KotlinModule dependencyModule) {
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            super(requestingVariant, dependencyModule, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/project/model/VariantResolution$AmbiguousVariants;", "Lorg/jetbrains/kotlin/project/model/VariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KotlinModule;", "matchingVariants", "", "(Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;Lorg/jetbrains/kotlin/project/model/KotlinModule;Ljava/lang/Iterable;)V", "getMatchingVariants", "()Ljava/lang/Iterable;", "kotlin-project-model"})
    public static final class AmbiguousVariants
    extends VariantResolution {
        @NotNull
        private final Iterable<KotlinModuleVariant> matchingVariants;

        @NotNull
        public final Iterable<KotlinModuleVariant> getMatchingVariants() {
            return this.matchingVariants;
        }

        public AmbiguousVariants(@NotNull KotlinModuleVariant requestingVariant, @NotNull KotlinModule dependencyModule, @NotNull Iterable<? extends KotlinModuleVariant> matchingVariants) {
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            Intrinsics.checkNotNullParameter(matchingVariants, (String)"matchingVariants");
            super(requestingVariant, dependencyModule, null);
            this.matchingVariants = matchingVariants;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/project/model/VariantResolution$Companion;", "", "()V", "fromMatchingVariants", "Lorg/jetbrains/kotlin/project/model/VariantResolution;", "requestingVariant", "Lorg/jetbrains/kotlin/project/model/KotlinModuleVariant;", "dependencyModule", "Lorg/jetbrains/kotlin/project/model/KotlinModule;", "matchingVariants", "", "kotlin-project-model"})
    public static final class Companion {
        @NotNull
        public final VariantResolution fromMatchingVariants(@NotNull KotlinModuleVariant requestingVariant, @NotNull KotlinModule dependencyModule, @NotNull Collection<? extends KotlinModuleVariant> matchingVariants) {
            VariantResolution variantResolution;
            Intrinsics.checkNotNullParameter((Object)requestingVariant, (String)"requestingVariant");
            Intrinsics.checkNotNullParameter((Object)dependencyModule, (String)"dependencyModule");
            Intrinsics.checkNotNullParameter(matchingVariants, (String)"matchingVariants");
            switch (matchingVariants.size()) {
                case 0: {
                    variantResolution = new NoVariantMatch(requestingVariant, dependencyModule);
                    break;
                }
                case 1: {
                    variantResolution = new VariantMatch(requestingVariant, dependencyModule, (KotlinModuleVariant)CollectionsKt.single((Iterable)matchingVariants));
                    break;
                }
                default: {
                    variantResolution = new AmbiguousVariants(requestingVariant, dependencyModule, (Iterable<? extends KotlinModuleVariant>)matchingVariants);
                }
            }
            return variantResolution;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

