/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;

public abstract class FqNameBase {
    protected FqNameBase() {
        if (!(this instanceof FqName) && !(this instanceof FqNameUnsafe)) {
            throw new AssertionError((Object)"do not use this class directly");
        }
    }

    @NotNull
    protected abstract String asString();

    @NotNull
    private FqNameUnsafe toFqNameUnsafe() {
        if (this instanceof FqName) {
            return ((FqName)this).toUnsafe();
        }
        if (this instanceof FqNameUnsafe) {
            return (FqNameUnsafe)this;
        }
        throw new AssertionError();
    }

    public final boolean equalsTo(@Nullable FqName that) {
        return that != null && this.equalsTo(that.toUnsafe());
    }

    public final boolean equalsTo(@Nullable FqNameUnsafe that) {
        return this.toFqNameUnsafe().equals(that);
    }

    @NotNull
    public abstract Name shortNameOrSpecial();

    @NotNull
    public abstract List<Name> pathSegments();
}

