/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererImpl;
import org.jetbrains.kotlin.renderer.NameShortness;
import org.jetbrains.kotlin.types.JetType;

public class DescriptorRendererBuilder {
    private NameShortness nameShortness = NameShortness.SOURCE_CODE_QUALIFIED;
    private boolean withDefinedIn = true;
    private Set<DescriptorRenderer.Modifier> modifiers = EnumSet.allOf(DescriptorRenderer.Modifier.class);
    private boolean startFromName = false;
    private boolean debugMode = false;
    private boolean classWithPrimaryConstructor = false;
    private boolean verbose = false;
    private boolean unitReturnType = true;
    private boolean normalizedVisibilities = false;
    private boolean showInternalKeyword = true;
    private boolean prettyFunctionTypes = true;
    private boolean uninferredTypeParameterAsName = false;
    private boolean includePropertyConstant = false;
    private boolean includeSynthesizedParameterNames = true;
    private boolean withoutFunctionParameterNames = false;
    private boolean withoutTypeParameters = false;
    private boolean withoutSuperTypes = false;
    private Function1<JetType, JetType> typeNormalizer = new Function1<JetType, JetType>(){

        public JetType invoke(JetType type2) {
            return type2;
        }
    };
    private boolean renderDefaultValues = true;
    private boolean flexibleTypesForCode = false;
    private boolean secondaryConstructorsAsPrimary = true;
    @NotNull
    private DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy = DescriptorRenderer.OverrideRenderingPolicy.RENDER_OPEN;
    @NotNull
    private DescriptorRenderer.ValueParametersHandler valueParametersHandler = new DescriptorRenderer.DefaultValueParameterHandler();
    @NotNull
    private DescriptorRenderer.TextFormat textFormat = DescriptorRenderer.TextFormat.PLAIN;
    @NotNull
    private Collection<FqName> excludedAnnotationClasses = Collections.emptyList();
    private boolean receiverAfterName = false;
    private boolean renderCompanionObjectName = false;

    @NotNull
    public DescriptorRendererBuilder setNameShortness(NameShortness shortness) {
        this.nameShortness = shortness;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setWithDefinedIn(boolean withDefinedIn) {
        this.withDefinedIn = withDefinedIn;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setModifiers(Set<DescriptorRenderer.Modifier> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setModifiers(DescriptorRenderer.Modifier ... modifiers) {
        return this.setModifiers(KotlinPackage.setOf((Object[])modifiers));
    }

    @NotNull
    public DescriptorRendererBuilder setStartFromName(boolean startFromName) {
        this.startFromName = startFromName;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setClassWithPrimaryConstructor(boolean classWithPrimaryConstructor) {
        this.classWithPrimaryConstructor = classWithPrimaryConstructor;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setUnitReturnType(boolean unitReturnType) {
        this.unitReturnType = unitReturnType;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setNormalizedVisibilities(boolean normalizedVisibilities) {
        this.normalizedVisibilities = normalizedVisibilities;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setShowInternalKeyword(boolean showInternalKeyword) {
        this.showInternalKeyword = showInternalKeyword;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setOverrideRenderingPolicy(@NotNull DescriptorRenderer.OverrideRenderingPolicy overrideRenderingPolicy) {
        this.overrideRenderingPolicy = overrideRenderingPolicy;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setValueParametersHandler(@NotNull DescriptorRenderer.ValueParametersHandler valueParametersHandler) {
        this.valueParametersHandler = valueParametersHandler;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setTextFormat(@NotNull DescriptorRenderer.TextFormat textFormat) {
        this.textFormat = textFormat;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setExcludedAnnotationClasses(@NotNull Collection<FqName> excludedAnnotationClasses) {
        this.excludedAnnotationClasses = excludedAnnotationClasses;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setPrettyFunctionTypes(boolean prettyFunctionTypes) {
        this.prettyFunctionTypes = prettyFunctionTypes;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setUninferredTypeParameterAsName(boolean uninferredTypeParameterAsName) {
        this.uninferredTypeParameterAsName = uninferredTypeParameterAsName;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setIncludePropertyConstant(boolean includePropertyConstant) {
        this.includePropertyConstant = includePropertyConstant;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setIncludeSynthesizedParameterNames(boolean includeSynthesizedParameterNames) {
        this.includeSynthesizedParameterNames = includeSynthesizedParameterNames;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setWithoutTypeParameters(boolean withoutTypeParameters) {
        this.withoutTypeParameters = withoutTypeParameters;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setWithoutFunctionParameterNames(boolean withoutFunctionParameterNames) {
        this.withoutFunctionParameterNames = withoutFunctionParameterNames;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setReceiverAfterName(boolean receiverAfterName) {
        this.receiverAfterName = receiverAfterName;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setRenderCompanionObjectName(boolean renderCompanionObjectName) {
        this.renderCompanionObjectName = renderCompanionObjectName;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setWithoutSuperTypes(boolean withoutSuperTypes) {
        this.withoutSuperTypes = withoutSuperTypes;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setRenderDefaultValues(boolean renderDefaultValues) {
        this.renderDefaultValues = renderDefaultValues;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setTypeNormalizer(@NotNull Function1<JetType, JetType> typeNormalizer) {
        this.typeNormalizer = typeNormalizer;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setFlexibleTypesForCode(boolean flexibleTypesForCode) {
        this.flexibleTypesForCode = flexibleTypesForCode;
        return this;
    }

    @NotNull
    public DescriptorRendererBuilder setSecondaryConstructorsAsPrimary(boolean secondaryConstructorsAsPrimary) {
        this.secondaryConstructorsAsPrimary = secondaryConstructorsAsPrimary;
        return this;
    }

    @NotNull
    public DescriptorRenderer build() {
        return new DescriptorRendererImpl(this.nameShortness, this.withDefinedIn, this.modifiers, this.startFromName, this.debugMode, this.classWithPrimaryConstructor, this.verbose, this.unitReturnType, this.normalizedVisibilities, this.showInternalKeyword, this.prettyFunctionTypes, this.uninferredTypeParameterAsName, this.overrideRenderingPolicy, this.valueParametersHandler, this.textFormat, this.excludedAnnotationClasses, this.includePropertyConstant, this.includeSynthesizedParameterNames, this.withoutFunctionParameterNames, this.withoutTypeParameters, this.receiverAfterName, this.renderCompanionObjectName, this.withoutSuperTypes, this.typeNormalizer, this.renderDefaultValues, this.flexibleTypesForCode, this.secondaryConstructorsAsPrimary);
    }
}

