/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import com.google.protobuf.ExtensionRegistryLite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.serialization.NameSerializationUtil;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.utils.UtilsPackage;

public final class PackageData {
    private final NameResolver nameResolver;
    private final ProtoBuf.Package packageProto;

    @NotNull
    public static PackageData read(@NotNull byte[] bytes, @NotNull ExtensionRegistryLite registry) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            NameResolver nameResolver = NameSerializationUtil.deserializeNameResolver(in);
            ProtoBuf.Package packageProto = ProtoBuf.Package.parseFrom(in, registry);
            return new PackageData(nameResolver, packageProto);
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
    }

    public PackageData(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Package packageProto) {
        this.nameResolver = nameResolver;
        this.packageProto = packageProto;
    }

    @NotNull
    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public ProtoBuf.Package getPackageProto() {
        return this.packageProto;
    }

    @NotNull
    public byte[] toBytes() {
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            NameSerializationUtil.serializeNameResolver(result, this.nameResolver);
            this.packageProto.writeTo(result);
            return result.toByteArray();
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
    }
}

