/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class ValueParameterDescriptorImpl
extends VariableDescriptorImpl
implements ValueParameterDescriptor {
    private Boolean hasDefaultValue;
    private final boolean declaresDefaultValue;
    private final JetType varargElementType;
    private final int index;
    private final ValueParameterDescriptor original;
    private final Set<ValueParameterDescriptor> overriddenDescriptors = new LinkedHashSet<ValueParameterDescriptor>();
    private boolean overriddenDescriptorsLocked = false;
    private final Set<? extends ValueParameterDescriptor> readOnlyOverriddenDescriptors = Collections.unmodifiableSet(this.overriddenDescriptors);

    public ValueParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @Nullable ValueParameterDescriptor original, int index, @NotNull Annotations annotations2, @NotNull Name name, @NotNull JetType outType, boolean declaresDefaultValue, @Nullable JetType varargElementType, @NotNull SourceElement source) {
        super(containingDeclaration, annotations2, name, outType, source);
        this.original = original == null ? this : original;
        this.index = index;
        this.declaresDefaultValue = declaresDefaultValue;
        this.varargElementType = varargElementType;
    }

    public void setType(@NotNull JetType type2) {
        this.setOutType(type2);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean hasDefaultValue() {
        this.computeDefaultValuePresence();
        return this.hasDefaultValue;
    }

    @Override
    public boolean declaresDefaultValue() {
        return this.declaresDefaultValue && ((CallableMemberDescriptor)this.getContainingDeclaration()).getKind().isReal();
    }

    private void computeDefaultValuePresence() {
        if (this.hasDefaultValue != null) {
            return;
        }
        this.overriddenDescriptorsLocked = true;
        if (this.declaresDefaultValue) {
            this.hasDefaultValue = true;
        } else {
            for (ValueParameterDescriptor descriptor2 : this.overriddenDescriptors) {
                if (!descriptor2.hasDefaultValue()) continue;
                this.hasDefaultValue = true;
                return;
            }
            this.hasDefaultValue = false;
        }
    }

    @Override
    @Nullable
    public JetType getVarargElementType() {
        return this.varargElementType;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor getOriginal() {
        return this.original == this ? this : this.original.getOriginal();
    }

    @Override
    @NotNull
    public ValueParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor.isEmpty()) {
            return this;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitValueParameterDescriptor(this, data2);
    }

    @Override
    public boolean isVar() {
        return false;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor copy(@NotNull DeclarationDescriptor newOwner, @NotNull Name newName) {
        return new ValueParameterDescriptorImpl(newOwner, null, this.index, this.getAnnotations(), newName, this.getType(), this.declaresDefaultValue(), this.varargElementType, SourceElement.NO_SOURCE);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return Visibilities.LOCAL;
    }

    @Override
    @NotNull
    public Set<? extends ValueParameterDescriptor> getOverriddenDescriptors() {
        return this.readOnlyOverriddenDescriptors;
    }

    @Override
    public void addOverriddenDescriptor(@NotNull ValueParameterDescriptor overridden) {
        assert (!this.overriddenDescriptorsLocked) : "Adding more overridden descriptors is not allowed at this point: the presence of the default value has already been calculated";
        this.overriddenDescriptors.add(overridden);
    }
}

