/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;

public class IntersectionTypeConstructor
extends AnnotatedImpl
implements TypeConstructor {
    private final Set<JetType> intersectedTypes;
    private final int hashCode;

    public IntersectionTypeConstructor(Annotations annotations2, Collection<JetType> typesToIntersect) {
        super(annotations2);
        assert (!typesToIntersect.isEmpty()) : "Attempt to create an empty intersection";
        this.intersectedTypes = new LinkedHashSet<JetType>(typesToIntersect);
        this.hashCode = ((Object)this.intersectedTypes).hashCode();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        return this.intersectedTypes;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    public String toString() {
        return IntersectionTypeConstructor.makeDebugNameForIntersectionType(this.intersectedTypes);
    }

    private static String makeDebugNameForIntersectionType(Iterable<JetType> resultingTypes) {
        StringBuilder debugName = new StringBuilder("{");
        Iterator<JetType> iterator2 = resultingTypes.iterator();
        while (iterator2.hasNext()) {
            JetType type2 = iterator2.next();
            debugName.append(type2.toString());
            if (!iterator2.hasNext()) continue;
            debugName.append(" & ");
        }
        debugName.append("}");
        return debugName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntersectionTypeConstructor that = (IntersectionTypeConstructor)o;
        return !(this.intersectedTypes != null ? !((Object)this.intersectedTypes).equals(that.intersectedTypes) : that.intersectedTypes != null);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

